#import <activity.h>
#import "Balls.h"
#import "Ball.h"
#import "Position.h"
#import "StringRepresentation.h"

@implementation Balls

+ create: aZone
{
  return [super create: aZone];
}
- buildObjects
{
  Position *pos;
  
  theBalls = [List create: [self getZone]];
 
  [StringRepresentation resetToChar: '0'];
  while ((pos = [StringRepresentation getNextPos]) != nil)
  {
    Ball* ball = [Ball create: [self getZone]];
    [ball setX: [pos getX] Y: [pos getY]];
    [theBalls addFirst: ball];
        [pos drop];
  }
  return self;
}
- setWorld: aWorld
{
  [theBalls forEach: M(setWorld:) : aWorld];
  return self;
}
- buildActions
{
  ballsActions = [ActionGroup create: self];
  [ballsActions createActionForEach: theBalls message: M(step)];

  ballsSchedule = [Schedule createBegin: self];
  [ballsSchedule setRepeatInterval: 1];
  ballsSchedule = [ballsSchedule createEnd];
  [ballsSchedule at: 0 createAction: ballsActions];

  return self;
}
- activateIn: swarmContext
{
  [ballsSchedule activateIn: swarmContext];
  return self;
}
@end
