#define __USE_FIXED_PROTOTYPES__  // for gcc headers
#import <space.h>
#import <simtools.h>
#import <collections.h>

#import "MatureForest.h"
#import "Tree.h"
#import "Species.h"

@implementation MatureForest

-addTree: aTree atX: (int) xVal Y: (int) yVal {
  [super addTree: aTree atX: xVal Y: yVal] ;
  ( ((Species *) ( ((Tree *)aTree )->species ) )->numberOfTrees )++ ;
  return self ;
}

-step {
  id aTree, index ;

  [treeList forEach: M(step)] ;

  index = [exitQ begin: [self getZone]] ;
  while( (aTree = [index next]) ){
    [treeList remove: aTree] ;
    [treeGrid putObject: nil atX: [aTree getX] Y: [aTree getY]] ;
    [index remove] ;
    [aTree drop] ;
  }
  [index drop] ;

  return self ;
}

-diedTree: aTree {
  [exitQ addLast: aTree] ;
  return self ;
}

@end








