#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <tkobjc.h>
#import <collections.h>
#import <simtools.h>
#import "ForestModelSwarm.h"
#import "Species.h"
#import "YoungForest.h"

@interface ForestObserverSwarm : GUISwarm {
  int displayFrequency ;
  int showSeedDistribution ;
  int showPopulationGraph ;

  int speciesNumber ;
  id speciesList ;

  id displayList ;
  id rasterList ;

  id displayActions;
  id displaySchedule;

  ForestModelSwarm * forestModelSwarm;

  XColormap * colormap;

  ZoomRaster * forestRaster;
  ZoomRaster * youngForestRaster;
  ZoomRaster * fireRaster;

  id popGraph, speciesGraph, entropyGraph ;
  id speciesEntropy ;

  Object2dDisplay *treeDisplay;
  Object2dDisplay *youngForestDisplay;
  Value2dDisplay *fireDisplay;
}

// Methods overriden to make the Swarm.
+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;
-showAgeLevel ;
-showSpecies ;
@end

