// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// Object to represent position of objects in the world.  Just a
// grid2d with special tokens stored in it. We do ugly things with
// pointers and ints for now to store objects - what's the right solution?

#import <space/Discrete2d.h>
#import <gui.h>

typedef int SortParcel;

@interface SortSpace: Discrete2d
{
  int numTypes;
  float density;
}

- setNumTypes: (int)n;
- setDensity: (float)f;
- createEnd;

- (SortParcel)pickupAtX: (int) x Y: (int) y;
- (BOOL)drop: (SortParcel) object AtX: (int) x Y: (int) y;
- (int)num8NeighboursAtX: (int)x Y: (int)y Type: (SortParcel)type;
- (int)num4NeighboursAtX: (int)x Y: (int)y Type: (SortParcel)type;

- drawSelfOn: (id <Raster>)r;
@end
