// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// Version kkheb2ly es igual, pero para una hebbiana de dos capas...

// Now compiles cleanly for swarm version 0807

// kkcl.m es una adaptacion, para probar CompLearning

#import <defobj.h>
#import <tkobjc.h>	// For all the definitions and stuff
#import <simtools.h>	// For simulation parameters

#import "Hebb2Layer.h"
#import "CompLearning.h"

#define INPUTSIZE 2

#define STEPS 1000


SimParameters * simParameters;

void doForm();

char *Colors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
};

void main( int argc, char** argv) {

    id aZone;			// Allocation zone
    id neura;			// Neural network
    unsigned i,j, error;
    float inp[INPUTSIZE];	// Generic input vector
    BLTGraph *errorGraph, *wgtGraph;
    GraphElement *errorData, *inpData, **wgtData;
    char Labels[10];

    // Initialize swarm
    initSwarm( argc, argv);

    doForm();

    aZone = [Zone create: NULL];

    if ( nnType ) {		   // Hebb with 2 layers
	neura = [Hebb2Layer createBegin: aZone];
	[neura setLayerSize: INPUTSIZE: numClasses : numNeurons]; 
	[neura setTrainingConstant: alpha : beta ];
    } else {
	neura = [CompLearning createBegin: aZone];
	[neura setLayerSize: INPUTSIZE: numNeurons ]; 
	[neura setTrainingConstant: alpha ];
	[neura setClasses: numClasses];
	[neura setOrderedLabels];
    }
    [neura setRandomWeights];
    if ( ! (neura = [neura createEnd])  ) { // Neural network created
	[InvalidCombination raiseEvent: "Neural network not created"];
    }

    // Create Graph
    errorGraph = [BLTGraph create: aZone];
    [errorGraph title: "Error" ];
    [errorGraph axisLabelsX: "Time" Y: "Error"];
    [errorGraph packWith: "-fill both"];
    sprintf( Labels, "Error" );
    errorData = [errorGraph createElement];
    [errorData setLabel: Labels ];
    [errorData setColor: "blue"];

    // Create Graph
    wgtGraph = [BLTGraph createParent: [errorGraph getParent]];
    [wgtGraph title: "Weight Wandering" ];
    [wgtGraph axisLabelsX: "WeightX" Y: "WeightY"];
    [wgtGraph setScaleModeX: 1 Y: 1]; // "Loose" mode
    [wgtGraph packWith: "-fill both"];
    wgtData = ( GraphElement ** ) malloc( numNeurons * sizeof(GraphElement *));
    for ( j = 0; j < numNeurons; j ++ ) {
	sprintf( Labels, "Weights %d", j );
	wgtData[j] = [wgtGraph createElement];
	[wgtData[j] setLabel: Labels ];
	[wgtData[j] setColor: Colors[j]];
	[wgtData[j] setSymbol: "diamond"];
    }
    inpData =  [wgtGraph createElement];
    [[[inpData setLabel: "Input"] setColor: "Purple"] setSymbol: "circle"];

    i = 0; error = 0;
    while ( [simControl getAllDone] == 0 ) {
	unsigned output;	   // 0 or 1
	float yValue;

	while( ! simControl->running ) {
	    Tk_DoOneEvent(0);
	}

	while( Tk_DoOneEvent(TK_ALL_EVENTS|TK_DONT_WAIT))
	    ;
	for ( j = 0 ; j < INPUTSIZE; j ++ ) {
	    inp[j] = [uniformRandom rFloat] * 2 -1 ;
	}

	// x > 0 == class 0; x <= 0 class 1

	[inpData resetData];
	[inpData addX:  inp[0] Y: inp[1] ];
	output = [neura feedForward: inp ];
//	printf( "Input %f %f Output %d\n", inp[0], inp[1], output );
	if ( (( output == 0 ) && ( inp[0] > 0 )) // Two classes >0 and <= 0
	     || (( output == 1 ) && ( inp[0] <=0 ) ) ){
	    [neura train: 1];
	} else {
	    error++;
	    [neura train: -1 ];
	}

	for ( j = 0; j < numNeurons; j ++ ) {
	    float w1, w2;
	    [wgtData[j] resetData];
	    if ( nnType ) {
		 w1 = [neura getWeights: 0: j: 0 ];
		 w2 =  [neura getWeights: 0: j: 1 ];
	    } else {
		 w1 = [neura getWeights: j: 0 ];
		 w2 =  [neura getWeights: j: 1 ];
	    }
	    [wgtData[j] addX:  w1 Y: w2 ];
	}

	yValue =  error*1.0/(i+1);
	[errorData addX:  i Y: yValue ];
	i++;
    }
}


// this is the current mechanism for setting simulation parameters.
// it will be changed when experiment objects are written.
void
doForm() {
#define NUMPARAMETERS 4
  Parameter p[NUMPARAMETERS] = {
    {"Number of output/hidden neurons", &numNeurons, TCL_LINK_INT},
    {"Training Parameter alpha", &alpha, TCL_LINK_DOUBLE},
    {"Training Parameter beta", &beta, TCL_LINK_DOUBLE},
    {"Check for Hebb2Layer ", &nnType, TCL_LINK_BOOLEAN}
  };
  
  simParameters = [SimParameters createBegin: globalZone];
  [simParameters setParameterList: p Num: NUMPARAMETERS];
  if ( !( simParameters = [simParameters createEnd] ) ){
      [InvalidCombination raiseEvent: "La jodiste" ];
  }
  [simParameters readValues: simControl];
}



