// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#include <stdlib.h>

#include "CRNN.h"

@implementation CRNN

// size and so:
-setNumberNeurons: (unsigned) _n {
    unsigned i;
    numNeurons = _n;

    // Dim everything...
    y = (float*) calloc( _n, sizeof(float));
    yPlus = (float*) calloc( _n, sizeof(float));
    
    for ( i = 0; i < numNeurons; i ++ ) {
	y[i] = yPlus[i] = 0;
    }
    inputs = (float*) calloc( _n, sizeof(float));
    bias = (float*) calloc( _n, sizeof(float));
    taus = (float*) calloc( _n, sizeof(float));
    weights = (float*) calloc( _n*_n, sizeof(float));
    return self;
}

// Weight-related functions inherited from NN
-setRandomWeights {		// Randomize weights, result [-1,1]
    unsigned i;
    for ( i = 0; i < numNeurons*numNeurons; i++ ) {
      weights[i]=(float)[uniformDblRand getDoubleWithMin:-1.0L withMax: 1.0L];
    }

    // Set biases to 0
    for ( i = 0; i < numNeurons; i++ ) {
	bias[i] = 0;
	taus[i] = 1;
    }
    return self;
}

-setFromString: (unsigned char *) _str{
    return nil;
}	// 2 bytes for each weight


-createEnd {
    if ( !numNeurons || !y || !yPlus || !inputs 
	 || !bias || !weights || !taus ) {
	[InvalidCombination raiseEvent: "La cagaste, Burt Lancaster...\n"];
	return nil;
    }
    return self;
}

-free {
    free(y);
    free(yPlus);
    free(inputs);
    free(bias);
    free(weights);
    free(taus);
    [self drop];
    return nil;
}

// info-related functions
// I/O related functions
-(unsigned) getInpSize { 
    return numNeurons;
}
		
-(BOOL) getLayers {		// True if multilayer <only>
    return 0;			// Concept does ot apply
}

// Input/Output related functions
-clamp: (float *) inpVec {
    unsigned i, j;
    for ( i = 0; i < numNeurons; i ++ ) {
	yPlus[i] = inpVec[i] - y[i];
	for ( j = 0; j < numNeurons; j ++ ) {
	    yPlus[i] += weights[j*numNeurons+i]*sigmoid(y[j]-bias[j]);
	}
	y[i] += yPlus[i]/taus[i];
    }
    return self;
}

-getActivation: (float * ) _act {
    memcpy(  _act, y, numNeurons*sizeof(float));
    return self;
}

@end
