// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <defobj.h>
#import <gui.h>
#import <simtoolsgui.h>
#import <simtools.h>

#import "IPDagent.h"		// CRNN declarations

#define NUMVARS 3
#define WIDTH 400
#define HEIGHT 250
//___________________________________________________________
void
main (int argc, const char **argv)
{

  IPDagent* agent[2];			// Agents
  id <Frame> aFrame;
  id <Entry> entry[NUMVARS]; // To get number of neurons
  id <Label> label[NUMVARS];
  char Labels[NUMVARS][30] = {"Memory length",
			      "Strategy-1", "Strategy-2"};
  char Colors[2][6] = {"Green", "Blue"};

  id <ControlPanel> controlPanel;	// Usually in GUISwarm
  id <ActionCache> actionCache;
#if 0
  id displayActions;
  id displaySchedule;
#endif
  unsigned j;
  
  id <Graph> historyGraph, scoreGraph;
  id <GraphElement> history[2], score[2];

  unsigned  memoryLength = 3, strategy[2] = { 0x56, 0x91};
  unsigned i, timeLine=1;

  // Initialize swarm
  initSwarm (argc, argv);

  // Create entry forms
  aFrame=[Frame create: globalZone];
  for (i = 0; i < NUMVARS; i++)
    {
      entry[i] = [Entry createParent: aFrame ];  
      [entry[i] pack];
      label[i] = [Label createParent: aFrame];
      [[label[i] setText: Labels[i]] pack];
    }
  // Now assign types and variables
  [entry[0] linkVariableInt: (void *)&memoryLength];
  [entry[1] linkVariableInt: (void *)&strategy[0]];
  [entry[2] linkVariableInt: (void *)&strategy[1]];

  // Create Graph
  historyGraph = [Graph createBegin: globalZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (historyGraph);
  historyGraph = [historyGraph createEnd];

  [historyGraph setWidth: WIDTH Height: HEIGHT];
  [historyGraph setTitle: "HistoryGraph" ];
  [historyGraph setAxisLabelsX: "Time" Y: "Action"];
  
  // lines and points
  for ( i = 0; i < 2; i ++ ) {
    char aux[7];
    history[i] = [historyGraph createElement];
    sprintf( aux, "Agent%d", i + 1 );
    [history[i] setLabel: aux ];
    [history[i] setColor: Colors[i]];
  }
  [historyGraph pack];
  
  // Attractor graph
  scoreGraph = [Graph createBegin: globalZone];
  [scoreGraph setParent: [historyGraph getParent]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (scoreGraph);
  scoreGraph = [scoreGraph createEnd];

  [scoreGraph setWidth: WIDTH Height: HEIGHT];
  [scoreGraph setTitle: "Score" ];
  [scoreGraph setAxisLabelsX: "Time" Y: "Score"];
  
  for ( i = 0; i < 2; i ++ ) {
    char aux[7];
    score[i] = [scoreGraph createElement];
    sprintf( aux, "Agent%d", i + 1 );
    [score[i] setLabel: aux ];
    [score[i] setColor: Colors[i]];
  }
  [scoreGraph pack];

  // actions and controlpanel
  controlPanel = [ControlPanel create: globalZone];
  actionCache = [ActionCache createBegin: globalZone];
  [actionCache setControlPanel: controlPanel];
  actionCache = [actionCache createEnd];

  [actionCache waitForControlEvent];

#if 0  
  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: globalZone];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  displaySchedule = [Schedule createBegin: globalZone];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
#endif

  // Create Agents
  for ( j = 0; j < 2; j ++ ) {
    agent[j] = [IPDagent createBegin: globalZone];
    [agent[j] setStrategy: strategy[j] withMemory: memoryLength ];
    [agent[j] setHistory: MASK32];	
    agent[j] = [agent[j] createEnd];
  }

  while ( [controlPanel getState] !=  ControlStateQuit) {
   
    unsigned action[2], i;

    while ([controlPanel getState] != ControlStateRunning)
      [actionCache waitForControlEvent];
    [actionCache doTkEvents];
    [actionCache deliverActions];

    for ( i = 0; i < 2; i ++ ) {
      action[i] = [ agent[i] action ]; // get agent action given history
      [history[i] addX: timeLine Y: action[i]];
      [score[i] addX: timeLine Y: [agent[i] getAverage]];
    }

#if 0
    [agent[0] updateAgent: ((action[0] << 1) | action[1]) atIter: timeLine];
    [agent[1] updateAgent: ((action[1] << 1) | action[0]) atIter: timeLine];
#else
    [agent[0] updateAgent: ((action[0] << 1) | action[1])];
    [agent[1] updateAgent: ((action[1] << 1) | action[0])];
#endif
    timeLine++;
  }

}



