// GA.m
// code for methods belonging to GA object class

#import <random.h>

#import "EvolvableIPDagent.h"

@implementation EvolvableIPDagent

// genotype bit operators

-bitMutate {
  int k,m;
  
  k = [uniformUnsRand getUnsignedWithMin: 0L withMax: length - 1]; 
  m = 1 << k;
  if ( m & strategy) {		// if mutation position is 1
    k = m ^ 0xffffffffU;
    strategy &= k;
  } else {
    strategy |= m;
  }
  return self;
}

-doubleMutate {
  if ( memory == MEMMAX ) 
    return self;		// Too big...
  strategy = (strategy << length) | strategy;
  memory++;
  length*=2;			// Increase memory and effective bitlength
  return self;
}

-splitMutate {
  int m,n;
  if ( memory == 1 ) 
    return self;		// Too small...
  memory--;
  length >>=1;					  // new length
  m = (1 << length) - 1;			  // mask of new mem length
  if ( [uniformDblRand getDoubleWithMin: 0.0L withMax: 1.0L ] >= 0.5){
    strategy = m & strategy;
  } else {
    n = (m << length) & strategy;
    strategy = (n >> length) & m; // why does >> bring in 1s?
				// if I don't have & m, is wrong
  }
  return self;
}

-cross: (EvolvableIPDagent*) otherAgent
{
  int maskHalf;
  unsigned halfLength;

  if ( length != [otherAgent getLength] ) { // Equalize them
    // Bring them to the same length
    while (length > [otherAgent getLength]) {	
      [otherAgent doubleMutate];
    }
    while (length < [otherAgent getLength]) {
      [self doubleMutate];
    }
  }

  halfLength = length >> 1;		
  maskHalf = (1 << halfLength) - 1;		// mask of 1/2 strategy
  
  strategy = ( strategy & (maskHalf << halfLength) ) 
    | (otherAgent->strategy & maskHalf);
  otherAgent->strategy = 
    ( otherAgent->strategy & (maskHalf << halfLength) ) 
    | (strategy & maskHalf);
  return self;
}

-(double) getFitness {
  return [self getAverage];
}
@end









