// Interact.m
// code for methods belonging to Interact object class

#import "Interact.h"
#import "gameworld.h"
#import "r250.h"

@implementation Interact

// set interact state

-setIterations: (int) iter
{
  num_iter = iter;

  return self;
}

-setError: (double) err
{
  error = err;

  return self;
}

// define agent interactions

-spatialInteract: (Grid2d *) a X: (int) xsize Y: (int) ysize
{
  int i,j;

  for (i=0;i<ysize;i++) {			  // reinit agent for new test
    for (j=0;j<xsize;j++) {
      id agent = [a getObjectAtX: j Y: i];
      [agent setReg1: [agent getID]];		  // tracks best neighbor
      [agent setReg2: 0];			  // tracks best score
      [agent dSetKey: 0];			  // tracks site avg
    }
  }

  // has each agent compete with agents in neighborhood for num_iter time steps
  for (i=0;i<ysize;i++) {
    for (j=0;j<xsize;j++) {
      // interact with wrap around
      [self agentSpatialInteract: [a getObjectAtX: j Y: i]
	    vs: [a getObjectAtX: (j+1)%xsize Y: i]];  // east
      [self agentSpatialInteract: [a getObjectAtX: j Y: i]
	    vs: [a getObjectAtX: j Y: (i+1)%ysize]];  // south
    }
  }
  
  // compute agent avg for step
  for (i=0;i<ysize;i++) {			
    for (j=0;j<xsize;j++) {
      id agent = [a getObjectAtX: j Y: i];
      [agent setAverage: [agent dGetKey]/4.0];
      // printf("%d: %g\n",i*ysize+j,[agent getAverage]);
    }
  }

  return self;
}

-agentSpatialInteract: (id) player1 vs: (id) player2
{
  double a1,a2,b1,b2;

  [player1 setAverage: 0];
  [player2 setAverage: 0];

  [self agentInteract: player1 vs: player2];

  a1 = [player1 getAverage];			  // get avg from run
  b1 = [player1 getReg2];			  // get best avg from neighbors
  a2 = [player2 getAverage];
  b2 = [player2 getReg2];

  [player1 dSetKey: ([player1 dGetKey] + a1)];
  [player2 dSetKey: ([player2 dGetKey] + a2)];

  // player1 update
  if (a1 > b1) {
    b1 = a1;
    [player1 setReg1: [player1 getID]];
  }
  if (a2 > a1 && a2 > b1) {
    b1 = a2;
    [player1 setReg1: [player2 getID]];
  }

  // player2 update
  if (a2 > b2) {
    b2 = a2;
    [player2 setReg1: [player2 getID]];
  }
  if (a1 > a2 && a1 > b2) {
    b2 = a1;
    [player2 setReg1: [player1 getID]];
  }
  
  [player1 setReg2: b1];
  [player2 setReg2: b2];
  
  return self;
}

-agentInteract: (id) player1 vs: (id) player2
{
  int i;
  char a1,a2;
  
  [player1 setHistory: MASK32];			  // reset history to all cooperate
  [player2 setHistory: MASK32];

  // define time step within local interaction to find avg payoff
  for (i=0;i<num_iter;i++) {
    a1 = [player1 action];		  // get agent action given history
    a2 = [player2 action];

    // perturb action if there is an error in communcation
    if ( dr250() < error ) {
      a1 = (a1==0);
    }
    if ( dr250() < error) {
      a2 = (a2==0);
    }
    
    [player1 updateAgent: ((a1 << 1) | a2)];
    [player2 updateAgent: ((a2 << 1) | a1)];

    // DEBUG stuff
    // [player1 debugState];
    // [player2 debugState];
  }

  [player1 updateAverage: num_iter];		  // calc avg from total  interactions
  [player2 updateAverage: num_iter];

  return self;
}

// get interact state

-(int) getIterations
{
  return(num_iter);
}

-(double) getError
{
  return(error);
}

@end

