// AgentObserverSwarm.m

/*
static char Id="$Id: AgentObserverSwarm.m,v 1.4 1999/01/16 22:51:05 alex Exp $";
*/

#import "AgentObserverSwarm.h"
#import "AgentModelSwarm.h"
#import <collections.h>
#import <objectbase.h>
#import <simtools.h>
#import <gui.h>

static const char *StackColors[] = {
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red", "purple", "green", "orange", "yellow",
  "blue", "red" 
};

const char *descr[] = {"First      ", "Second     ","Third      ", "Fourth     ",
                       "Fifth      ","Sixth      ", "Seventh    ", "Eighth     ", "Ninth      ", "Tenth      ",
                       "Eleventh   ","Twelfth    ", "Thirteenth ", "Fourteenth ", "Fifteenth  ",
                       "Sixteenth  ", "Seventeenth","Eighteenth ", "Nineteenth ", "Twentieth  ",
} ;

static unsigned numStackToShow = 10;

@implementation AgentObserverSwarm

-convert: (char *)buf : (char *)buf1
{
  int i, j=0;

  //printf("buffer = %s\n", buf);

  i=0;
  while (i<MAX_LENGTH){
    if (buf[i++] == ':') { // the separator we use for delineating comments and useful input data 
      j=i;  // will point to the char next to colon
      break;
    }
  }
  i=j+1; // to take into account the space between the colon and the input parameter
  j=0;
  while (buf[i] !='\0') { // is it end of buf?
    buf1[j++] = buf[i++]; // copy char by char
  }
  buf1[j] = '\0'; // add the last char

  //printf("buf1 = %s\n", buf1);

  return self;
}

// createBegin: here we set up the default observation parameters.
+ createBegin: aZone
{
  AgentObserverSwarm * obj;

  
  FILE *Input_parameters;
  char buffer[MAX_LENGTH], buffer_1[MAX_LENGTH];
  char Name[50]; // to get the name of a file for storing the results of an experiment
  int frequency, demo_choice, intensive_measures, iteration_threshold, choice_to_stop;

  // Superclass createBegin to allocate ourselves.
  obj = [super createBegin: aZone];

  Input_parameters = fopen("AgentObserver.data", "r");
  // Now fill in various simulation parameters with default values.
  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &frequency);
  [obj setDisplayFrequency: frequency];

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &demo_choice);
  [obj setDemoChoice: demo_choice]; // no demo choice, rather intensive measurements:
			  // DemoChoice and IntensiveMeasures are mutually exclusive

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &intensive_measures);
  [obj setIntensiveMeasures: intensive_measures];

  if ([obj getIntensiveMeasures] == [obj getDemoChoice])
    printf("You must choose between Demo mode and intensive run mode (check in AgentObserver.data!)\n");

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &iteration_threshold);
  [obj setIterationThreshold: iteration_threshold];

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &choice_to_stop);
  [obj setChoiceToStop: choice_to_stop];

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  strcpy(Name, buffer_1);
  [obj FileName: Name];

  fclose(Input_parameters);

  // Also, build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.
  if ([obj getDemoChoice]) {
    id <ProbeMap> probeMap;

    probeMap = [EmptyProbeMap createBegin: aZone];
    [probeMap setProbedClass: [self class]];
    probeMap = [probeMap createEnd];

    // Add in a bunch of variables, one per simulation parameters
    [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

    // Now install our custom probeMap into the probeLibrary.
    [probeLibrary setProbeMap: probeMap For: [self class]];
  }

  return obj;
}

// createEnd: create objects we know we'll need. In this case, none,
// but you might want to override this.
-createEnd {
  return [super createEnd];
}

// Create the objects used in the display of the model. This code is
// fairly complicated because we build a fair number of widgets. It's
// also a good example of how to use the display code.
- buildObjects
{
  id modelZone;	// zone for model.
  int i;
  
  //id agentToProbe;

  [super buildObjects];
  
  // First, we create the model that we're actually observing. The
  // model is a subswarm of the observer. We also create the model in
  // its own zone, so storage is segregated.
  modelZone = [Zone create: [self getZone]];
  agentModelSwarm = [AgentModelSwarm create: modelZone];
  
  if ([self getDemoChoice]) {
    // Now create probe objects on the model and ourselves. This gives a
    // simple user interface to let the user change parameters.
    CREATE_ARCHIVED_PROBE_DISPLAY (agentModelSwarm);
    CREATE_ARCHIVED_PROBE_DISPLAY (self);

    // Instruct the control panel to wait for a button event: we halt here
    // until someone hits a control panel button so the user can get a
    // chance to fill in parameters before the simulation runs

    // if DemoChoice = 1, then IntensiveMeasures = 0 and conversely.
    [actionCache waitForControlEvent];

    // Check now if the user hit the quit button: if so, abort.
    // we keep this even in the intensive measurement mode (a way to exit in a proper way!
    if ([controlPanel getState] == ControlStateQuit)
      return self;
  }

  // OK - the user has specified all the parameters for the simulation.
  // Now we're ready to start.

  // First, let the model swarm build its objects.
  [agentModelSwarm buildObjects];

  if ([self getDemoChoice]) {
    // Now get down to building our own display objects.
    // First, create a colormap: this is a global resource, the information
    // here is used by lots of different objects.
    colormap = [Colormap create: [self getZone]];
    for (i = 0; i < 63; i++)
      [colormap setColor: i ToRed: (double)i / 62.0 Green: 0 Blue: 0];
    // colour 63 is set to blue to display carrying agents
    [colormap setColor: 63 ToName: "blue"];
    // Colour 64 is set to green, to display free (non carrying) agents
    [colormap setColor: 64 ToName: "green"];
    // Colour 65 is set to white
    [colormap setColor: 65 ToName: "white"];
  }

  // Now go in to the agents in the model and set their colours to green (64)
  [[agentModelSwarm getAgentList] forEach: M(setAgtColor:) : (void *) 64];

  if ([self getDemoChoice]) {
  
    // Next, create a 2d window for display, set its size, zoom factor, title.
    worldRaster = [ZoomRaster create: [self getZone]];
    [worldRaster setColormap: colormap];
    [worldRaster setZoomFactor:12];
    [worldRaster setWidth: [[agentModelSwarm getWorldAgent] getSizeX]
			Height: [[agentModelSwarm getWorldAgent] getSizeY]];
    [worldRaster setWindowTitle: "World"];
    [worldRaster setX: 430 Y: 10];
    [worldRaster pack]; // draw the window.

    // Now create a Value2dDisplay: this is a special object that will
    // display arbitrary 2d value arrays on a given Raster widget.
    envDisplay = [Value2dDisplay createBegin: [self getZone]];
    [envDisplay setDisplayWidget: worldRaster colormap: colormap];
    [envDisplay setDiscrete2dToDisplay: [agentModelSwarm getWorldObject]];
    [envDisplay setDisplayMappingM: 512 C: 0];	  // turn [0,32768) -> [0,64)
    envDisplay = [envDisplay createEnd];

    // And also create an Object2dDisplay: this object draws agents on
    // the worldRaster widget for us, and also receives probes.
    agentDisplay = [Object2dDisplay createBegin: [self getZone]];
    [agentDisplay setDisplayWidget: worldRaster];
    [agentDisplay setDiscrete2dToDisplay: [agentModelSwarm getWorldAgent]];
    [agentDisplay setObjectCollection: [agentModelSwarm getAgentList]];
    [agentDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
    agentDisplay = [agentDisplay createEnd];
    // Also, tell the world raster to send mouse clicks to the agentDisplay
    // this allows the user to right-click on the display to probe the agts.
    [worldRaster setButton: ButtonRight Client: agentDisplay Message: M(makeProbeAtX:Y:)];

    // Create the graph widget to display stacks.
    StackGraph = [Graph create: [self getZone]];
    [StackGraph setTitle: "Evolution of the number of stacks"];
    [StackGraph setAxisLabelsX: "time" Y: "number of stacks"];
    [StackGraph setX: 10 Y: 10];
    [StackGraph setWidth: 400 Height: 260];
    [StackGraph pack]; 

    // Create one data element inside the graph for displaying stacks
    StackData = [StackGraph createElement];
    [StackData setLabel: "s"];

    StackGrapher = [ActiveGraph createBegin: [self getZone]];
    [StackGrapher setElement: StackData];
    [StackGrapher setDataFeed: agentModelSwarm];
    [StackGrapher setProbedSelector: M(getHeap)];
    StackGrapher = [StackGrapher createEnd];

    // Create the graph widget to display stacks.
    BiggestStackGraph = [Graph create: [self getZone]];
    [BiggestStackGraph setTitle: "Evolution of the size of the biggest stack"];
    [BiggestStackGraph setAxisLabelsX: "time" Y: "size"];
    [BiggestStackGraph setX: 10 Y: 300];
    [BiggestStackGraph setWidth: 400 Height: 260];
    [BiggestStackGraph pack]; 

    // Create one data element inside the graph for displaying stacks
    BiggestStackData = [BiggestStackGraph createElement];
    [BiggestStackData setLabel: "s"];

    BiggestStackGrapher = [ActiveGraph createBegin: [self getZone]];
    [BiggestStackGrapher setElement: BiggestStackData];
    [BiggestStackGrapher setDataFeed: agentModelSwarm];
    [BiggestStackGrapher setProbedSelector: M(getMaxSize)];
    BiggestStackGrapher = [BiggestStackGrapher createEnd];

    useHisto = [Histogram createBegin: globalZone];
    [useHisto setNumBins: numStackToShow];
    useHisto = [useHisto createEnd];
//      [useHisto setNumPoints: numStackToShow
//  	    Labels: descr
//  	    Colors: StackColors];
    [useHisto setColors: StackColors count: numStackToShow];
    [useHisto setLabels: descr count: numStackToShow];
    [useHisto setTitle: "Histogram of stacks"];
    [useHisto setAxisLabelsX: "Stack offset" Y: "Number of objects"];
    [useHisto setX: 10 Y: 590];
    [useHisto setWidth: 600 Height: 260];
    [useHisto pack];

    // Finally, we create a Probe display to probe a particular agent.
    // Probes can also be created on the fly, we just do this here for demo.

    //agentToProbe = [[agentModelSwarm getAgentList] first];
    //[probeDisplayManager createProbeDisplayFor: agentToProbe];
  }
    // All done - we're ready to build a schedule and go.
  return self;
}  

// Create the actions necessary for the simulation. This is where
// the schedule is built (but not run!)
// Here we create a display schedule - this is used to display the
// state of the world and check for user input. This schedule should
// be thought of as independent from the model - in particular, you
// will also want to run the model without any display.
-buildActions {
  [super buildActions];
  
  // First, let our model swarm build its own schedule.
  [agentModelSwarm buildActions];
  
  // Create an ActionGroup for display: a bunch of things that occur in
  // a specific order, but at one step of simulation time. Some of these
  // actions could be executed in parallel, but we don't explicitly
  // notate that here.

  displayActions = [ActionGroup create: [self getZone]];

  if ([self getDemoChoice]) {
    // Schedule up the methods to draw the display of the world
    [displayActions createActionTo: envDisplay          message: M(display)];
    [displayActions createActionTo: agentDisplay        message: M(display)];
    [displayActions createActionTo: worldRaster         message: M(drawSelf)];
    [displayActions createActionTo: StackGrapher        message: M(step)];
    [displayActions createActionTo: BiggestStackGrapher message: M(step)];
    [displayActions createActionTo: self                message: M(updateHisto)];
  }
  if ([self getDemoChoice]) {
    // Schedule the update of the probe displays
    [displayActions createActionTo: probeDisplayManager message: M(update)];
    // Finally, schedule an update for the whole user interface code.
    // This is crucial: without this, no graphics update and the control
    // panel will be dead. It's best to put it at the end of the display schedule
  }

  if ([self getChoiceToStop] == 0) {
    [displayActions createActionTo: self		message: M(checkToStop)];
  } else if ([self getChoiceToStop] == 1) {
    [displayActions createActionTo: self		message: M(checkToStop1)];
  }  

  if ([self getDemoChoice]) {
    [displayActions createActionTo: actionCache        message: M(doTkEvents)];
  }

  // And the display schedule. Note the repeat interval is set from our
  // own Swarm data structure. Display is frequently the slowest part of a
  // simulation, so redrawing less frequently can be a help.
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency]; // note frequency!
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
    
  return self;
}  

// activateIn: - activate the schedules so they're ready to run.
// The swarmContext argument has to do with what we were activated *in*.
// Typically the ObserverSwarm is the top-level Swarm, so it's activated
// in "nil". But other Swarms and Schedules and such will be activated
// inside of us.
-activateIn: (id) swarmContext {
  // First, activate ourselves (just pass along the context).
  [super activateIn: swarmContext];

  // Now activate our schedule in ourselves. This arranges for the
  // execution of the schedule we built.

  [displaySchedule activateIn: self];

  // Activate the model swarm in ourselves. The model swarm is a
  // subswarm of the observer swarm.
  [agentModelSwarm activateIn: self];
  

  if ([self getIntensiveMeasures])
    [[self getActivity] run];

  // Activate returns the swarm activity - the thing that's ready to run.
  return [self getActivity];

}

// You could override the "go" method here if you want something special
// to happen when the model and observer actually start running. But
// the default GUISwarm go is probably good enough.

-checkToStop
{
  if ( (([[agentModelSwarm getWorldObject] getStacks] == 1)&&([[agentModelSwarm getWorldObject] getBiggestStack] == [[agentModelSwarm getWorldObject] getInitObj]))  || ([agentModelSwarm getNumIterations]> [self getIterationThreshold])) {
    printf("Done in %d iterations\n", [agentModelSwarm getNumIterations]);
    [controlPanel setStateStopped];

    if ([self getIntensiveMeasures]) {
      FILE *Input_parameters;

      Input_parameters = fopen([self getFileName], "a");
      // be careful with this: works only for some experiments: there is a need to customize it!
      fprintf(Input_parameters, "%d\t%d\t%d\t%d\n", [agentModelSwarm getNumAgents], [agentModelSwarm getSeedValueObj], [[[agentModelSwarm getAgentList] first] getSeedDispl], [agentModelSwarm getNumIterations]);
      fclose(Input_parameters);
      [getTopLevelActivity() terminate]; // to leave automatically
    }
  } else {
    //update the number of iterations for statistics
    [agentModelSwarm IncrementNumIterations];
  }
  return self;
}

-checkToStop1
{
  if (([[agentModelSwarm getWorldObject] getStacks] == 1) || ([agentModelSwarm getNumIterations]> [self getIterationThreshold])) {
    printf("Done in %d iterations\n", [agentModelSwarm getNumIterations]);
    [controlPanel setStateStopped];


    if ([self getIntensiveMeasures]) {
      FILE *Input_parameters;

      Input_parameters = fopen([self getFileName], "a");
      // be careful with this: works only for some experiments: there is a need to customize it!
      fprintf(Input_parameters, "%d\t%d\%d\t%d\n", [agentModelSwarm getNumAgents], [agentModelSwarm getSeedValueObj], [[[agentModelSwarm getAgentList] first] getSeedDispl], [agentModelSwarm getNumIterations]);
      fclose(Input_parameters);
      [getTopLevelActivity() terminate]; // to leave automatically
    }
  } else {
    //update the number of iterations for statistics
    [agentModelSwarm IncrementNumIterations];
  }
  return self;
}

-setDemoChoice: (int)val
{
  DemoChoice = val;
  return self;
}

-setIntensiveMeasures: (int)val
{
  IntensiveMeasures = val;
  return self;
}

-(int)getDemoChoice
{
  return DemoChoice;
}

-(int)getIntensiveMeasures
{
  return IntensiveMeasures;
}

-setChoiceToStop: (int)val
{
  ChoiceToStop = val;
  return self;
}

-(int)getChoiceToStop
{
  return ChoiceToStop;
}

-FileName: (char *)name
{
  strcpy(FileNameExperiment, name);
  return self;
}

-(char *)getFileName
{
  return FileNameExperiment;
}

-setIterationThreshold: (int)val
{
  IterationThreshold = val;
  return self;
}
-(int)getIterationThreshold
{
  return IterationThreshold; 
}

-setDisplayFrequency: (int)val;
{
  displayFrequency = val;
  return self;
}

-(int)getDisplayFrequency
{
  return displayFrequency;
}

-updateHisto
{
  int nb, i, j;
  int histoList[numStackToShow];
  int listOffset[numStackToShow];
  int supsize, supoffset;


  nb = [agentModelSwarm getHeap];
  if (nb<=numStackToShow) { // current number of stacks reach number
                                                   // of stacks for histograms
 
    for (i=0; i<nb; i++) {
     histoList[i]= [[[agentModelSwarm getStackListForHisto] atOffset: i] getSize];
     listOffset[i]= [[[agentModelSwarm getStackListForHisto] atOffset: i] getOff];
    }
  
    for (i=nb; i<numStackToShow; i++) { // set the other elements to 0
      histoList[i]=0;
      listOffset[i]=0;
    }
    //for (i=0; i<nb; i++) {
     //printf("%d: offset = %d, size = %d\n", i, listOffset[i], histoList[i]);
    //}

    // sort the list versus the offset
    for (i=0; i<nb-1; i++) {
      for (j=i+1; j<nb; j++) {
        if (listOffset[i] > listOffset[j]) {
          supoffset = listOffset[i];
          listOffset[i] = listOffset[j];
          listOffset[j] = supoffset;
          supsize = histoList[i];
          histoList[i] = histoList[j];
          histoList[j] = supsize;
        }
      }
    }
   
    [useHisto drawHistogramWithInt:histoList];
  }
  return self;
}

@end

/*
$Log: AgentObserverSwarm.m,v $
Revision 1.4  1999/01/16 22:51:05  alex
* AgentObserverSwarm.m ([AgentObserverSwarm -buildObjects]): Initialize the
  Histogram instance `useHisto' according to the latest version of protocol
  (as of Swarm 1.4).

Revision 1.3  1998/08/25 19:25:06  mgd
* Makefile: Include from etc/swarm.
(SWARMHOME): Default to 1998-08-25.
(APPLIBS): Remove -lspace.

* AgentObserverSwarm.m ([AgentObserverSwarm -buildObjects]):
Use setX:Y: instead of setPositionX:Y:.

* AgentObserverSwarm.h: Include analysis.h.

Revision 1.2  1998/02/04 01:08:06  mgd
* main.m (main): Constify argv.

* WorldObject.m ([WorldObject -RemoveObjects:::]): Initialize
oldsize and newsize to avoid warning.

* Stack.h: Include objectbase.h instead of swarmobject.h.

* Makefile (APPLIBS): Remove -lneuro and -lga.

* AgentProbaCamera.m ([AgentProbaCamera -determinesIntervalAngle:]):
Initialize intervalAng to avoid warning.
([AgentProbaCamera -determinesAngle:]):
Initialize angle to avoid warning.
([AgentProbaCamera -drawSelfOn:]): Make argument to drawSelfOn:
an id <Raster> instead of being statically typed.

* AgentProbaCamera.h:  Include objectbase.h and gui.h
instead of swarmobject.h and tkobjc/Raster.h.
([-drawSelfOn:r]): Make argument to drawSelfOn: an id <Raster>
instead of being statically typed.

* AgentObserverSwarm.m: Include objectbase.h instead of
swarmobject.h.  Constify StackColors and descr.  Include
simtools.h and gui.h.
(-convert::): Initialize j to avoid warning.
([AgentObserverSwarm +createBegin:]): Make probeMap comply with
the ProbeMap protocol rather than being statically typed.
([AgentObserverSwarm -buildObjects]): Use
CREATE_ARCHIVED_PROBE_DISPLAY for agentModelSwarm and
AgentObserverSwarm.  Send waitForControlEvent to actionCache
rather than controlPanel.  Create colormap from Colormap instead
of XColormap. Use setDisplayWidget:colormap: rather than
setDisplayWidget:Colormap:.  Create StackGraph from Graph instead
of BLTGraph. Use renamed setTitle: and setAxisLabelX:Y:.  Likewise
for BiggestStackGraph and useHisto.
([AgentObserverSwarm -updateHisto]): Use renamed
drawHistogramWithInt:.

* AgentObserverSwarm.h: Include gui.h instead of tkobjc.h.
Include objectbase.h instead of swarmobject.h.
(AgentObserverSwarm): Make colormap comply with the Colormap
protocol instead of being statically typed to XColormap.
Make worldRaster comply with the ZoomRaster protocol instead of
being statically typed.  Make StackGraph and BiggestStackGraph
comply with the Graph protocol instead of being statically
typed to BLTGraph.  Make StackData and BiggestStackData comply
with the GraphElement protocol instead of being statically typed.
Make StackGrapher and BiggestStackGrapher comply with the
ActiveGraph protocol instead of being statically typed.  Make
useHisto comply with the Histogram protocol instead of being
statically typed to Histo.

* AgentModelSwarm.m ([AgentModelSwarm -convert::]): Initialize
j to avoid warning.
([AgentModelSwarm +createBegin:]): Use id <ProbeMap> instead of
statically typing probeMap.

* AgentModelSwarm.h: Change swarmobject.h to objectbase.h.

Revision 1.1.1.1  1998/02/03 23:40:03  mgd
EnhApp import

Revision 1.2  1997/04/03 15:53:48  chantem
modified to position windows

Revision 1.1  1997/04/02 09:00:08  chantem
Initial revision

Revision 1.1  1997/03/25 12:40:14  chantem
Initial revision

*/
