#import "AgentModelSwarm.h"
#import <random.h>

/*
static char Id="$Id: AgentModelSwarm.m,v 1.3 1998/02/28 08:47:18 mgd Exp $";
*/

@implementation AgentModelSwarm

// These methods provide access to the objects inside the ModelSwarm.
// These objects are the ones visible to other classes via message call.
// In theory we could just let other objects use Probes to read our state,
// but message access is frequently more convenient.


- convert:  (char *)buf : (char *)buf1
{
  int i, j=0;

  //printf("buffer = %s\n", buf);

  i=0;
  while (i<MAX_LENGTH){
    if (buf[i++] == ':') { // the separator we use for delineating comments and useful input data 
      j=i;  // will point to the char next to colon
      break;
    }
  }
  i=j+1; // to take into account the space between the colon and the input parameter
  j=0;
  while (buf[i] !='\0') { // is it end of buf?
    buf1[j++] = buf[i++]; // copy char by char
  }
  buf1[j] = '\0'; // add the last char

  //printf("buf1 = %s\n", buf1);

  return self;
}

-getAgentList {
  return agentList;
}

-getWorldAgent {
  return worldAgent;
}

-getWorldObject {
  return worldObject;
}

-(int)getHeap
{
  return [worldObject getStacks];
}

-(int)getMaxSize
{
  return [worldObject getBiggestStack];
}

-(int)getSeedValueObj
{
  return seedValueObjects;
}

-(int)getSeedValueLocAgt
{
  return seedValueLocAgt;
}

-IncrementNumIterations
{
  numIterations +=1;
  return self;
}

-(int)getNumIterations
{
  return numIterations;
}

-setModTypeOfSpace: (int)type_of_space
{
  TypeOfSpace = type_of_space;
  return self;
}

-(int)getModTypeOfSpace
{
  return TypeOfSpace;
}

-(int)getNumAgents
{
  return numAgents;
}


-getStackListForHisto
{ 
  return [worldObject getStackList];
}

// This method isn't normally used, but is convenient when running probes:
// it lets you easily clone a agent and drag it into the model.
-addAgent: (id) agt {
  [agentList addLast: agt];
  return self;
}


// createBegin: here we set up the default simulation parameters.
+ createBegin: aZone
{
  AgentModelSwarm * obj;
  id <ProbeMap> probeMap;

  FILE *Input_parameters;
  char buffer[MAX_LENGTH], buffer_1[MAX_LENGTH];
  

  // First, call our superclass createBegin - the return value is the
  // allocated AgentModelSwarm object.
  obj = [super createBegin: aZone];

  Input_parameters = fopen("GeneralFeatures.data", "r");
  // Now fill in various simulation parameters with default values.
  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->numAgents);

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->worldXSize);

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->worldYSize);

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->InitNumObjects);

  if (obj->InitNumObjects > (32000 - basisColorForObj) ) printf ("You may run into troubles: change the basisColorForObj into WorldObject.m file: you should decrease basisColorForObj!\n");
  // assumption: number of objects should be strictly lower than the number of cells
  // number objects + nber agents lower than or equal to number of cells
  // we do not check it: it is the user's responsability
  obj->InitNumStacks = obj->InitNumObjects; //for that, we need to ensure one object per cell

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->seedValueObjects);

  obj->seedValueLocAgt = obj->seedValueObjects + 1;

  fscanf(Input_parameters, "%[^\n]\n", buffer);
  [obj convert: buffer: buffer_1];
  sscanf(buffer_1, "%d", &obj->TypeOfSpace);

  fclose(Input_parameters);

  obj->numIterations = 0;

  // And build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameter
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numAgents"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "InitNumObjects"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "InitNumStacks"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "seedValueObjects"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "seedValueLocAgt"
				    inClass: [self class]]];
  // And one method, the "addagent" method for a probe demo.
  // we also hide the return value for this message probe, just for nicety.
  //[probeMap addProbe: [[probeLibrary getProbeForMessage: "addAgent:"
  //			     inClass: [self class]]
  //			setHideResult: 1]];

  // Now install our custom probeMap into the probeLibrary.
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

// createEnd: we could create some objects here if we knew we needed
// them. But this method is called before the user is allowed to fill
// in any customization of the model, so we defer most object creation
// to later. (In this example, this method does nothing at all and could
// just be inherited. But it's here to show you a place to customize.)
-createEnd {
  return [super createEnd];
}

// Now it's time to build the model objects. We use various parameters
// inside ourselves to choose how to create things.
-buildObjects {
  int i;
  id randG;
  id uRand;
  id randGOrient;
  id uRandOrient;
  int k, l;
  
  // for the generator
  randG = [PMMLCG1 createBegin: [self getZone]];
  [randG setStateFromSeed: seedValueLocAgt];
  randG = [randG createEnd]; 
  // for the distribution
  uRand = [UniformInteger createBegin: [self getZone]];
  [uRand setGenerator: randG];
  uRand = [uRand createEnd];

  //randG = [[PMMLCG1 alloc] initSeed: seedValueLocAgt];	  // seeds from clock
  //uRand = [[[Uniform alloc] init] setGenerator: randG];


  // for the generator
  randGOrient = [PMMLCG1 createBegin: [self getZone]];
  [randGOrient setStateFromSeed: 5000];
  randGOrient = [randGOrient createEnd]; 
  // for the distribution
  uRandOrient = [UniformInteger createBegin: [self getZone]];
  [uRandOrient setGenerator: randGOrient];
  uRandOrient = [uRandOrient createEnd];

  //randGOrient = [[PMMLCG1 alloc] initSeed: 5000];	  // seeds from clock
  //uRandOrient = [[[Uniform alloc] init] setGenerator: randGOrient];

  // allow our parent class to build anything.
  [super buildObjects];
  
  // First, set up objects used to represent the worlds.
  worldObject = [WorldObject createBegin: [self getZone]];
  [worldObject setSizeX: worldXSize Y: worldYSize];
  worldObject = [worldObject createEnd];
 
  for (k=0; k<worldYSize; k++){
    for (l=0; l<worldXSize; l++) {
      [worldObject putValue: backgroundColor atX:l Y: k];
    }
  }

  [worldObject InitNumberOfObj: InitNumObjects];
  [worldObject InitSetObjects: seedValueObjects];

  // Now set up the grid used to represent agent position
  worldAgent = [Grid2d createBegin: [self getZone]];
  [worldAgent setSizeX: worldXSize Y: worldYSize];
  worldAgent = [worldAgent createEnd];

  // Create a list to keep track of the agents in the model.
  agentList = [List create: [self getZone]];
  
  // Create agents themselves. This is a fairly complex step, as is
  // appropriate: the agents are essential aspects of the simulation.
  // First, a quick hack. During creation we might put several agents
  // in the same square. This is a design flaw, but it's one that's not
  // fatal, so we ask the world object not to warn us about it. This is
  // not an example to be emulated :-)
  [worldAgent setOverwriteWarnings: 0];


  // Now a loop to create a bunch of agents.
  for (i = 0; i < numAgents; i++) {
    AgentProbaCamera *aagt;
    int coordX, coordY;

    FILE *Input_parameters;
    char buffer[MAX_LENGTH], buffer_1[MAX_LENGTH];
    int seedvalue_for_agentProbaCameraDispl, seedvalue_for_agentProbaCameraCarr, carried_object;
    int  seedvalue_for_agentProbaCameraCCW;
    float alpha;
    double rotationAngle;
    int numberOfPixelSeen, numberOfRotationOnSite;
    float agentlens;
    int orient;

    Input_parameters = fopen("AgentProbaCamera.data", "r");

    // Create the agent, set the creation time variables
    aagt = [AgentProbaCamera createBegin: [self getZone]];
    [aagt setWorlds: worldAgent: worldObject];
    aagt = [aagt createEnd];

    // Add the agt to the end of the list.
    [agentList addLast: aagt];

    //coordX = [uRand rMax: worldXSize];
    //coordY = [uRand rMax: worldYSize];
    coordX = [uRand getIntegerWithMin: 0L withMax: worldXSize-1];
    coordY = [uRand getIntegerWithMin: 0L withMax: worldYSize-1];
    // to avoid to place an agent on a cell containing an object
    while (([worldObject getValueAtX: coordX Y: coordY] != backgroundColor) || ([worldAgent getValueAtX: coordX Y: coordY] != 0)){
      //printf("occupied: x= %d, y= %d\n", coordX, coordY);
      //coordX = [uRand rMax: worldXSize];
      //coordY = [uRand rMax: worldYSize];
      coordX = [uRand getIntegerWithMin: 0L withMax: worldXSize-1];
      coordY = [uRand getIntegerWithMin: 0L withMax: worldYSize-1];
    }
    //printf("agt: x= %d, y= %d\n", coordX, coordY);

    [aagt setX: coordX Y: coordY];

    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &seedvalue_for_agentProbaCameraDispl);
    [aagt setSeedDispl: seedvalue_for_agentProbaCameraDispl+i]; // seed for the random generator of the agent (for moving)

    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &seedvalue_for_agentProbaCameraCarr);
    [aagt setSeedCarrying: seedvalue_for_agentProbaCameraCarr+i]; // seed for the random generator of the agent (for carrying)
 
    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &seedvalue_for_agentProbaCameraCCW);
    [aagt setSeedCCW: seedvalue_for_agentProbaCameraCCW+i]; // seed for the random generator of the agent (for rotation CW or CCW)
  
    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &carried_object);
    [aagt setCarriedObj: carried_object]; //init carried objects to zero
    
    // set a flag: for probabilistic agents
    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%f", &alpha);
    [aagt setAlpha: alpha]; // subsequently to the tests made by thierry.

    //orient = [uRandOrient rMax: 8];
    orient = [uRandOrient getIntegerWithMin: 0L withMax: 7];
    rotationAngle = [aagt determinesAngle: orient];
    //printf("orient is %d and %lf\n", orient, rotationAngle);
    [aagt setRotAngle: rotationAngle];

    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &numberOfPixelSeen); 
    [aagt setNbPointSeen: numberOfPixelSeen];

    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%d", &numberOfRotationOnSite);
    [aagt setNberOfRotOnSite: numberOfRotationOnSite];

    fscanf(Input_parameters, "%[^\n]\n", buffer);
    [self convert: buffer: buffer_1];
    sscanf(buffer_1, "%f", &agentlens);
    [aagt setCameraInit];

    [[[aagt getCamera] sendIntr] modifyf: (float)(agentlens)];

    //[[[aagt getCamera] sendIntr] ViewAngle]; // give additional information such as view angle

    fclose(Input_parameters);
    
  }

  [worldAgent setOverwriteWarnings: 1];		  // ok, done cheating.

  return self;
}

// Here is where the model schedule is built, the data structures
// that define the simulation of time in the mode. The core is an
// actionGroup that has a list of actions. That's then put in a Schedule.
-buildActions {
  [super buildActions];
  
  // Create the list of simulation actions. We put these in an action
  // group, because we want these actions to be executed in a specific
  // order, but these steps should take no (simulated) time. The
  // M(foo) means "The message called <foo>". You can send a message
  // To a particular object, or ForEach object in a collection.

  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionForEach: agentList message: M(step)];

  // Then we create a schedule that executes the modelActions. modelActions
  // is an ActionGroup, by itself it has no notion of time. In order to
  // have it executed in time, we create a Schedule that says to use
  // the modelActions ActionGroup at particular times.
  // This schedule has a repeat interval of 1, it will loop every time step.
  // The action is executed at time 0 relative to the beginning of the loop.
  
  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

// Now set up the model's activation. swarmContext indicates where
// we're being started in - typically, this model is run as a subswarm
// of an observer swarm.
-activateIn: (id) swarmContext {
  // First, activate ourselves via the superclass activateIn: method.
  // Just pass along the context: the activity library does the right thing.
  [super activateIn: swarmContext];

  // Now activate our own schedule.
  [modelSchedule activateIn: self];

  // Finally, return our activity.
  return [self getSwarmActivity];
}

@end

/*
$Log: AgentModelSwarm.m,v $
Revision 1.3  1998/02/28 08:47:18  mgd
* AgentProbaCamera.m: Include random.h instead of simtools.h.

* WorldObject.m: Likewise.

* AgentObserverSwarm.h: Don't include objectbase.h, space.h,
activity.h, gui.h, collections.h, or simtools.h.  Include
simtoolsgui/GUISwarm.h and simtoolsgui.h.

* AgentModelSwarm.m: Include random.h instead of simtools.h.

Revision 1.2  1998/02/04 01:08:05  mgd
* main.m (main): Constify argv.

* WorldObject.m ([WorldObject -RemoveObjects:::]): Initialize
oldsize and newsize to avoid warning.

* Stack.h: Include objectbase.h instead of swarmobject.h.

* Makefile (APPLIBS): Remove -lneuro and -lga.

* AgentProbaCamera.m ([AgentProbaCamera -determinesIntervalAngle:]):
Initialize intervalAng to avoid warning.
([AgentProbaCamera -determinesAngle:]):
Initialize angle to avoid warning.
([AgentProbaCamera -drawSelfOn:]): Make argument to drawSelfOn:
an id <Raster> instead of being statically typed.

* AgentProbaCamera.h:  Include objectbase.h and gui.h
instead of swarmobject.h and tkobjc/Raster.h.
([-drawSelfOn:r]): Make argument to drawSelfOn: an id <Raster>
instead of being statically typed.

* AgentObserverSwarm.m: Include objectbase.h instead of
swarmobject.h.  Constify StackColors and descr.  Include
simtools.h and gui.h.
(-convert::): Initialize j to avoid warning.
([AgentObserverSwarm +createBegin:]): Make probeMap comply with
the ProbeMap protocol rather than being statically typed.
([AgentObserverSwarm -buildObjects]): Use
CREATE_ARCHIVED_PROBE_DISPLAY for agentModelSwarm and
AgentObserverSwarm.  Send waitForControlEvent to actionCache
rather than controlPanel.  Create colormap from Colormap instead
of XColormap. Use setDisplayWidget:colormap: rather than
setDisplayWidget:Colormap:.  Create StackGraph from Graph instead
of BLTGraph. Use renamed setTitle: and setAxisLabelX:Y:.  Likewise
for BiggestStackGraph and useHisto.
([AgentObserverSwarm -updateHisto]): Use renamed
drawHistogramWithInt:.

* AgentObserverSwarm.h: Include gui.h instead of tkobjc.h.
Include objectbase.h instead of swarmobject.h.
(AgentObserverSwarm): Make colormap comply with the Colormap
protocol instead of being statically typed to XColormap.
Make worldRaster comply with the ZoomRaster protocol instead of
being statically typed.  Make StackGraph and BiggestStackGraph
comply with the Graph protocol instead of being statically
typed to BLTGraph.  Make StackData and BiggestStackData comply
with the GraphElement protocol instead of being statically typed.
Make StackGrapher and BiggestStackGrapher comply with the
ActiveGraph protocol instead of being statically typed.  Make
useHisto comply with the Histogram protocol instead of being
statically typed to Histo.

* AgentModelSwarm.m ([AgentModelSwarm -convert::]): Initialize
j to avoid warning.
([AgentModelSwarm +createBegin:]): Use id <ProbeMap> instead of
statically typing probeMap.

* AgentModelSwarm.h: Change swarmobject.h to objectbase.h.

Revision 1.1.1.1  1998/02/03 23:40:03  mgd
EnhApp import

Revision 1.2  1997/04/02 09:24:10  chantem
can now choose to rotate counter clockwise or clockwise

Revision 1.1  1997/04/02 09:00:08  chantem
Initial revision

Revision 1.1  1997/03/25 12:40:14  chantem
Initial revision

*/


