#import "ObserverSwarm.h"
#import "ModelSwarm.h"
#import <objectbase.h> // ProbeMap
#import <gui.h> // Canvas, GUI_UPDATE_IDLE_TASKS
#import <graph.h> // redistribute

@implementation ObserverSwarm

// createBegin: here we set up the default observation parameters.
+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "ringDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "boingDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

- buildObjects
{
  id modelZone;	

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  modelSwarm = [ModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  CREATE_ARCHIVED_PROBE_DISPLAY (modelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  [actionCache waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  graphCanvas = [Canvas createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (graphCanvas);
  graphCanvas = [graphCanvas createEnd];

  [[graphCanvas setHeight: 500] setWidth: 500];
  [graphCanvas setWindowTitle: "Dynamic Graph"];
  [graphCanvas packFillLeft: YES];
  GUI_UPDATE_IDLE_TASKS();
 
  [modelSwarm setGraphCanvas: graphCanvas];
  [modelSwarm buildObjects];

  return self;
}  

- ringDistribute
{
  [[modelSwarm getTheNet] redistribute];
  return self;
}

- boingDistribute
{
  [[modelSwarm getTheNet] boingDistribute];
  return self;
}

- buildActions
{
  [super buildActions];
  
  [modelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  [displayActions createActionTo: [modelSwarm getTheNet]
                  message: M(boingStep)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

- activateIn: swarmContext
{
  [super activateIn: swarmContext];

  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

@end
