// -*- mode: objc; -*-
// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#ifndef _POPULATION_P
#define _POPULATION_P

#import "Chromosome.h"		// Chromosome protocol

@protocol Population

// setting
-(void) addPopulation: (unsigned) _num;	// Adds to the population
-evaluate;			// Evaluates all member of the population
-newGeneration;			// Generational renovation


// using
-(id) getList;			// Return population list
-(id<Chromosome>) getBest;	// Returns the best genome
-(double) getBestFitness;	// Fitness of the best genome
-(unsigned) getGenerations;
-(unsigned) getGenerationCount; // Generations already run
@end

#endif




