// -*- mode: objc
// Copyright (C) 1995-1999 The Santa Fe Institute, JJ Merelo
// No warranty implied, see LICENSE for terms.

// Protocol for chromosomes; defines the interface they should
// have to be used by the Population objects.

#ifndef __CHROMOSOME_P
#define __CHROMOSOME_P

@protocol Chromosome

// Creation Phase--------------
-setLength: (unsigned) _len;	// Set chromosome length in bytes
-setRandomInit;			// Initializes randomly
-setID: (const char*)_ID;		// Set unique ID

// Setting---------------------
// to set fitness;
-setFitness: (double) _fitness;

// unary operators -- probably changed afterwards into "create" operators
- Clone : (id<Chromosome>) _chrom withMutation: (float) _mutProb;

- Duplicate : (id<Chromosome>) _chrom 
	From: (unsigned) _l1 To: (unsigned) _l2 
withMutation: (float) _mutProb;

- Kill : (id<Chromosome>) _chrom
   From: (unsigned) _l1 To: (unsigned) _l2;

- Swap:  (id<Chromosome>) _chrom 
      : (unsigned) _l1 with: (unsigned) _l2
  size: (unsigned) _bytes;	// Swap whole byte/loci

- RemoveReinsert : (id<Chromosome>) _chrom 
		 : (unsigned) _l1 To: (unsigned) _l2 
	     size: (unsigned) _bytes;

// binary operators
-Mate: (id<Chromosome>) _chrom1 And: (id<Chromosome>) _chrom2
withMutation: (float) _mutationRate ; // 2-point crossover

// Using the chromosome--------------------------------------
// info functions
- (unsigned)      getLength;
-                 getGenotype;
- (double)        getFitness;
- (unsigned char) getGene: (unsigned) offset;
-                 hexaPrint;	// Print binary chrom in hexa
- (char* )        getID;	// Get unique ID, whatever that is

@end

#endif
