#define MAX_PERIODICITY 7

#import <graph.h>

@interface BoolNode: DiGraphNode {

  BOOL state[MAX_PERIODICITY*2];    // maintain a state history - to define attractors!

  BOOL newState;                    // don't have graph buffered 
  int function;                     // Boolean function used to calculate new state
  
  int boolId;                       // numerical ID of Boolean node 
  int periodicity;                  // classifies the periodicity of the node

  id boolNet ;                      // Boolean network it is a part of...
}

// create-time messages

-setBoolFunc: (int) bf;             // set the boolean function type for the element
-setEntityId: (int) the_name;
-makeLinkFrom:  aNode ;             // create a link from "aNode"
-makeLinkFromWithInt: (int) aNumber ; // create a link from node with number "aNumber"
-placeX: (int) x Y: (int) y;

-createEnd;

// using messages
-(int) getBoolFunc;
-setBoolNet: aBoolNet ;

-(BOOL) getBoolState;               // get the current state of the element
-displayNodeState;                  // updates the display of the node on the "canvas"
-setBoolState: (BOOL) state;	    // force the element's Boolean state

-(int) getPeriodicity;              // gets the periodicity of the node

-(const char *) getInstanceName;
-(int) getInstanceNumber;

-dropLinks;
-getInputLinks;                     // returns the list of input links
-(int) getNumInputs;                // gets the number of inputs 
-(int) getNumOutputs;               // gets the number of outputs
-stepRule ;                         // each element handles calculation of new state
-update ;                           // updates the state of the Boolean network 
                                    // called after stepRule
-(int) updatePeriodicity;

@end
