// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* Space with multiple dicrete2d layers */

#import <space.h>	
#import <objectbase/SwarmObject.h>	
#import <collections.h>
#import <space/Diffuse2d.h>	
#import <objectbase.h>	
#define MAX 10000     // my set maximal value at discrete2d

@interface MultiScaled2d: SwarmObject {
  id gridList;
  int size;
  float maxScaledVal;
  float ioUnit;
}

-createGridsN: (int) num sizeX: (int)x sizeY: (int)y 
                    withDiffusion: (double) diffusion 
		    withEvaporation: (double) evaporation; 
- setMaxScaledVal: (float) max; 
- setIOUnit: (float) u; 
- (float) getMaxScaledVal;
- getId: (int)index;

- (float) getValueAtX: (int) x Y: (int) y atIndex: (int) i;
- (int)   getUnscaledValueAtX: (int) x Y: (int) y atIndex: (int) i;
- (float) getTotalAtIndex: (int) i;
- (long) getUnscaledTotalAtIndex: (int) i;
- putValue: (float) v atX: (int) x Y: (int) y atIndex: (int) i;
- putValueUpd: (float) v atX: (int) x Y: (int) y atIndex: (int) i;
- putUnscaledValueUpd: (int) v atX: (int) x Y: (int) y atIndex: (int) i; 
- (float) incrementValue: (float) delta atX: (int) x Y: (int) y atIndex: (int) i;
- (float) incrementValueUpd: (float)delta atX: (int)x Y: (int)y atIndex: (int)i;
- (int)   incrementUnscaledValueUpd: (int)delta atX:(int)x Y:(int)y atIndex:(int)i;
- (float) takeValue: (float)val atX: (int) x Y: (int) y atIndex: (int) i;
- (float) takeValueUpd: (float)val atX: (int) x Y: (int) y atIndex: (int) i;
- (int)   takeUnscaledValueUpd: (int)reqVal atX: (int) x Y: (int) y atIndex: (int)i;
- (float) updateInFlowBy: (float) val atIndex: (int) i;
- (float) updateOutFlowBy: (float) val atIndex: (int) i;

@end


