// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// ModelSwarm.h					

#import "Mag.h"
#import "Resource2d.h"
#import "MultiScaled2d.h"
#import "GeneticsFloat.h"
#import <objectbase/Swarm.h>
#import <space.h>
#import <objectbase.h>
#import <random.h>

#define MAXNUTRIS 10      // max. number of nutrients
#define MAXFILENAME 100  // max. lenght of simulation name
#define VisionGSize 4
#define MaxMRGSize 4
#define NutriSelGSize 4
#define EnzGeneSize 4
   
@interface ModelSwarm: Swarm
{
  int worldSize;
  int nutrisNum;
  float seedProb;                  
  double diffusion;
  double evaporation;
  float magDensity;
  float pMut;
  int minVision, maxVision;
  int min_MaxMR, max_MaxMR;
  int initSize;             // initial amount of nutri in Mag's stocks 
  int reproSize;            // treshold size when Mag reproduce itself 
  int ageLimit;             // age when agent dies     
  float deathRate;
  float ioTreshold;         // treshold setting when nutriSelGene is Inp/Outp/-
  float enzTreshold;        // treshold setting when enzyme production is T/F
  float Kmetab;             // coeficient for basal metabolism = K.w^exp
  float Kmove,K_move;       // abs.& rel.coef. for move metabolism = Km.w^exp
  float Kconsum,K_consum;   // abs.& rel.coef. for consumption size = Kc.w^exp
  float Ksatisf,K_satisf;   // abs.& rel.coef. for satisfaction metab = Ks.w^exp
  float enzymeCost,enzyme_Cost; // abs.& rel. coef. for enzyme metab = Ke.n.w^exp
  float Expon;
  unsigned initRandGenSeed; // initial state of Random generator 
  char *inFlow;             // string of InFlow values: e.g."10 20 10" 
  char *outFlow;            //   ..     OutFlow values
  char *initSeed;           //   ..     initial nutri seed values
  long inFlowArr[MAXNUTRIS*4+1];       // arrays of in/out/init Flow values 
  long outFlowArr[MAXNUTRIS*4+1];      //    converted from string input descr.above
  long initSeedArr[MAXNUTRIS*2+1];
  
  char *nutriUtils;                    // input string for nutriUtils 
  float nutriUtilsArr[MAXNUTRIS*2+1];   // array of nutriUtils values
  char *outTresh;                     //   .. for output Treshold vaules
  long outTreshArr[MAXNUTRIS*2+1];     //         outFlow = max outpTresh
  char *initNutriGenes;                    //   .. for initial Genes preset values
  float initNutriGenesArr[MAXNUTRIS*2+1];   // 
  char *initEnzymeGenes;      // string for enzymes production flag Gene
  float initEnzymeGenesArr[MAXNUTRIS*2+1];   // .. array of enzymes prod. flags
  char *optNutriFracs;        // string for optimal nutri fractions in world
  float optNutriFracsArr[MAXNUTRIS*2+1];     // .. array of opt. nutri fracs
  float drain;              // amount <0,1> of non-kept produced nutri 
                            //which can be flooded away by outFlow

  float magsBiomass[MAXNUTRIS+1];       // array of nutri possesed by Mags (for graph)
  float magsContribNutris[MAXNUTRIS*2+1];    // array of extra nutri added/taken by Mags
  float totNutriProd[MAXNUTRIS*2+1];  // total produced nutri by Mags in one time step
  float totNutriCons[MAXNUTRIS*2+1];  // total consumed nutri by Mags in a time step
  float totFreeBiomCons[MAXNUTRIS*2+1];  // total consum.free biomass by Mags in a time step
  float totMagInFracs[MAXNUTRIS+1];   // sum of all input consump. fractions of all Mags
  float inEntropy;      // entropy of agents' inputs
  float outEntropy;     // entropy of agents' outputs
  float enzEntropy;     // entropy of agents' enzyme production flags
  float optFracsError;             // difference between real and optimal NutriFracs
  float iFD;            // Ideal Free Distribution of mags consumtion over inflowing nutris
  int maxSpotNutri;     // max. value of nutri per spot 
  float ioUnit;         // amount of +/-units per spot in In/OutFlow
  char *simName;

  float moveMetabAvg;              // separately comp. avg of moveMetab value
                                   //      the need to count only moving Mags 
  float enzMetabAvg;              // separately comp. avg of enzyme metab value
                                   //      the need to count only Mags with enzymes
  int birthsNum, deathsNum;         // counters
  int ioDist[MAXNUTRIS*3+1];        // array of nutri type for distrib.graphs
  int ioCard[MAXNUTRIS*3+4];        // array of cardinality of Mags In/Out
  float realInFlow[MAXNUTRIS+1];  // global In/OutFlow nutri
  float realOutFlow[MAXNUTRIS+1];    
  float sumAllNutri[MAXNUTRIS+1];
  float totalNutris;               // sum of all nutrients of all types in env.
  float inCardAvg, inCardStd ;     // average and stand.deviation of Mags input 
  float outCardAvg, outCardStd;    //   or output cardinality
  float enzCardAvg, enzCardStd;    //   or cardinality of enzyme production flags 
  int mutCnt,tak;                  // temporary variables 
  int presetNutriGenes;                 // tag if random initNutriGenes value or preset 
  int presetEnzymeGenes;                // tag if random initEnzymeGenes value or preset 
  int setOutTresh;                 // tag if specified output treshold limit
  int cntMagsBiomass,cntContribNutri;    // help variable 
  int displayFreq;               // copy of variable from ObserverSwarm, to know
                                 // time step of graphs and save it in model.setup 
  int experimentTime;            // variable from observerSwarm to save it in 
                                 // the model.setup 
  
  

  id nutri;
  id nutrisList;
  id <Grid2d> world;
  id geneMap;

  id magList;
  id reaperQueue;
  id birthQueue;
  id modelActions;
  id modelSchedule;
}

- getWorld;
- (int) getNutrisNum;
- (int) getAgeLimit;
- (float) getDeathRate;
- (int) getBirthsNum;
- (int) getDeathsNum;
- (float) getKmetab;
- (float) getKmove;
- (float) getKconsum;
- (float) getKsatisf;
- (float) getEnzymeCost;
- (float) getExpon;
- (float *) getKmetabP;
- (float *) getKmoveP;
- (float *) getKconsumP;
- (float *) getKsatisfP;
- (float *) getEnzymeCostP;
- (float *) getExponP;
- getNutri;
- getNutriAtIndex: (int) i;
- getNutrisList;
- getMagList;
- getReaperQueue;
- getBirthQueue;
- (int) getReproSize;
- (int) getMutationsCnt;
- (float) getMoveMetabAvg;
- (float) getEnzMetabAvg;
- (float) getOptFracsError;
- (int *) getIODist;
- (int *) getIOCard;
- (char *) getSimName;
- (int) getMaxSpotNutri;
- (float) getMagsBiomass;
- (float) getContribNutri;
- (float) getTotNutriProd: (int) index;
- (float) getTotNutriCons: (int) index;
- (float) getTotFreeBiomCons: (int) index;
- (int) getOutFlowArr: (int) index;
- (float *) getOptNutriFracsArr;
- (float) getInCardAvg;
- (float) getInCardStd;
- (float) getOutCardAvg;
- (float) getOutCardStd;
- (float) getEnzCardAvg;
- (float) getEnzCardStd;
- (float) getInEntropy;
- (float) getOutEntropy;
- (float) getEnzEntropy;
- (float) getIFD;
- addTotNutriProd: (float) add atIndex: (int) index; 
- addTotNutriCons: (float) add atIndex: (int) index; 
- addTotFreeBiomCons: (float) add atIndex: (int) index; 
- setMutationsCnt: (int) c;
- addRandMagAtX: (int)x Y: (int)y;
- magDeath: (Mag *) mag;
- magBirth: (Mag *) mag;
- countMagStatistics;
- (int) convertStr: (char *) str toLongArr: (long *)arr;
- (int) convertStr: (char *) str toFloatArr: (float *)arr;
- updateIOCardStat;
- updateIOEntropy;
- loadRandGenSeed;
- loadMS;
- saveMSto: (char *) filename;
- setDisplayFreq: (int) freq;
- setExperimentTime: (unsigned) time;

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end



