// ObserverSwarm.h

#import "ModelSwarm.h"
#import <simtoolsgui/GUISwarm.h>

@interface ObserverSwarm: GUISwarm
{
  int displayFrequency, zoomFactor;             // parameters: update freq
                                                //             zoom

  id displayActions;                            // schedule data structs
  id displaySchedule;

  ModelSwarm *modelSwarm;                       // the Swarm we're observing

  // Lots of display objects. First, widgets

  id <Colormap> colorMap;                       // allocate colours
  id <ZoomRaster> worldRaster;                  // 2d display widget

 // Now, higher order display and data objects

  id <Value2dDisplay>  traceDisplay;            // display the traces
  id <Object2dDisplay> agentDisplay;            // display the agents
}

// Methods overriden to make the Swarm.

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end

