// ModelSwarm.h

#import "Agent.h"
#import "TraceSpace.h"
#import "RuleManager.h"
#import <objectbase/Swarm.h>
#import <space.h>

@interface ModelSwarm: Swarm
{
  int worldXSize, worldYSize;
  float exAnteTraceProb;
  float agentNumber;
  int manyAgentsInASquare;  // if = 1 allows multiple occupancy; see Agent.m

  TraceSpace * traces;
  id world;

  RuleManager * ruleManager;
  id agentList;
  id modelActions;
  id modelSchedule;
}

- getWorld;
- getTraces;
- getAgentList;

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end


