// Agent.m                                        

#import "Agent.h"
#import <random.h>

@implementation Agent

- setWorld: w Traces: tr agentsInASquare: (int)ag
{
   world = w;                   // he grid that contains agetns (lists of
                                // agents)
   traces = tr;                 // the space where traces (left by agents moving
                                // or ex ante generated) are registered

   manyAgentsInASquare = ag;    // if =1 multiple occupancy is allowed

   return self;
}

- setRuleManager: rp
{
  ruleManager = rp;
  return self;
}


- createEnd
{
   [super createEnd];

   worldXSize = [world getSizeX];
   worldYSize = [world getSizeY];

   return self;
}

- setX: (int) x Y: (int) y
{
  xPos = x;
  yPos = y;

  return self;
}

- setFirstStepDx: (int) dx  Dy: (int) dy     // first step is randomly
                                             // determinated in modelSwarm.m
{
  Dx=dx;
  Dy=dy;

  return self;
}

- step
{
  int newX, newY;

// information about environment and interactions with it are managed by
// each agent, which transfer to the ruleManager the data received from the
// environment (if necessary to apply rules), and its private information
// (if any)

  newX = xPos + Dx;
  newY = yPos + Dy;

  newX = (newX + worldXSize) % worldXSize;
  newY = (newY + worldYSize) % worldYSize;

// movement in allowed only if the destination square is free or if
// multiple occupancy is allowed

  if ([world numberOfObjectsAtX: newX Y: newY] == 0
      || manyAgentsInASquare == 1)
    {
      [world deleteObject: self atX: xPos Y: yPos];
      xPos = newX;
      yPos = newY;
      [world addFirst: self atX: newX Y: newY];
    }
  else return self;

// turning to right (no trace) or to left (trace)
  [ruleManager applyRulesToDx: Dx Dy: Dy XPos: xPos YPos: yPos
                               Traces: traces];
  Dx = [ruleManager getDx];
  Dy = [ruleManager getDy];


// the trace
  if ([traces getValueAtX: xPos Y: yPos] == 0)
                   [traces putValue: 1 atX: xPos Y: yPos];
  else             [traces putValue: 0 atX: xPos Y: yPos];

  return self;
}


- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: xPos Y: yPos Color: 2];
  return self;
}
  
@end

