// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 14/02/97.

// Definition du swarm charger de la migration des agents.

#import "MigrationSwarm.h"
#import "SpeedSwarm.h"

@implementation MigrationSwarm

// Reception de l'agent "anAgent" et mise dans dans la liste d'attente.
// Cette methode est utilisee par l'agent. 
-receiveAgent: anAgent {
  fprintf(stderr, "Reception d'un agent\nanAgent: %x\n", anAgent);
  [agentList addLast: anAgent];
  fprintf(stderr, "Reception d'un agent\nagentList: %x\n", agentList);
  return self;
}

// Les agents reference dans la file "agentList" sont deplaces.
// Les agents dans la file d'attente sont traites sequentiellement.
// Connaissant l'ancienne vitesse et la nouvelle vitesse de l'agent,
// il est possible de le supprimer du speedSwarm ou il se trouve pour
// l'ajouter dans le speedSwarm correspondant a sa vitesse.
-doMigration {
  //id tmpArray= [dispersionModelSwarm getSpeedSwarmArray];
  int oldSpeed, speed;
  Agent *currentAgent; // Agent en cours de traitement
  
  fprintf(stderr, "Lancement de la migration\nagentList=%x\n", agentList);
  while ([agentList getCount] != 0) {
    fprintf(stderr, "Migration d'un agent\n");
    // Agent en cours de traitement
    currentAgent= [agentList getFirst];

    // Obtention des vitesse
    oldSpeed= [currentAgent getOldSpeed];
    speed= [currentAgent getSpeed];

    // Retrait de l'ancien speedSwarm
    [[speedSwarmArray atOffset: oldSpeed] removeAgent: currentAgent];

    // Ajout dans le nouveau speedSwarm
    [[speedSwarmArray atOffset: speed] addAgent: currentAgent];

    // Suppresion dans la file d'attente
    [agentList removeFirst];
  }
  return self;
}

// Retourne le nouvea
//-(id) getNewSpeedSwarmArray;

// Creation d'un MigrationSwarm : initialisation
+createBegin: (id) aZone {
  MigrationSwarm *obj;

  // Creation de la file d'attente des agents migrants
  obj = [super createBegin: aZone];
  //  obj->speedSwarmArray= [Array create: [self getZone] 
  //			       setCount: [anArray getCount]];
//obj->speedSwarmArray= anArray;
  return obj;
} 

// Creation d'un MigrationSwarm : validation
-createEnd {
  return [super createEnd];
}

// Construction des objets du migrationSwarm
-initMigration: (id) speedSwarms {
  agentList= [List create: [self getZone]];
  speedSwarmArray= [Array create: [self getZone] 
			  setCount: [speedSwarms getCount]];
  speedSwarmArray= speedSwarms;
  return self;
}

// Mise en place du scheduler du migrationSwarm
// -buildActions {  
//   [super buildActions];

//   // Creation du groupe d'action. Il est vide comme celui du modelSwarm.
//   migrationActions = [ActionGroup create: [self getZone]];
//   [migrationActions createActionTo: self message: M(doMigration)];

//   // Creation du Scheduler
//   migrationSchedule = [Schedule createBegin: [self getZone]];
//   [migrationSchedule setRepeatInterval: 1];
//   migrationSchedule = [migrationSchedule createEnd];
//   [migrationSchedule at: 0 createAction: migrationActions];
  
//   return self;
// }

// // Lancement du scheduling
// -activateIn: (id) swarmContext {
//   // Activation du modele lui-meme par l'intermediaire de la superclasse
//   [super activateIn: swarmContext];

//   // Activation du scheduler du modele
//   [speedSwarmArray forEach: M(activateIn:) : self];

//   // renvoie sa propre activite
//   return [self getSwarmActivity];
// }

@end
