// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 20/01/97.
// Interface des agents.

#import <swarmobject.h>
#import <space.h>
#import "DensitySpace.h"
#import "MigrationSwarm.h"
#import <tkobjc/Raster.h>

@interface Agent: SwarmObject {
  Density actualDensity;          // Nombre actuel de voisins.
  Density idealDensity;           // Nombre ideal de voisins
  int convergenceFactor;          // Facteur de convergeance des densite
  int x, y;                       // Position dans l'espace
  int speed;                      // Vitesse de deplacement
  int oldSpeed;                   // Ancienne vitesse de deplacement
  float randomMoveProbability;	  // Tendance au mouvement aleatoire

  double unhappiness;             // Taux d'insatisfaction

  Grid2d *world;                  // Reference sur l'espace des positions
  DensitySpace *densityMap;       // Reference sur l'espace des densites
  id *migration;                  // Reference sur le swarm de migration
  int worldXSize, worldYSize;     // Taille de l'espace
  Color agentColor;	          // Couleur
}

// Creation de la reference sur l'espace.
-setWorld: (Grid2d *) w Density: (DensitySpace *) d;

// Validation de la creation de l'agent.
-createEnd;

// Methodes de manipulation de l'etat de l'agent.
-setIdealDensity: d;
-setConvergenceFactor: (int) c;
-setSpeed: (int) s ForInit: (int) b;
-setRandomMoveProbability: (float) p;
-setX: (int) x Y: (int) y;
-setMigrationRef: (id *) m;
-setAgentColor: (Color) c;

-(int) getOldSpeed;
-(int) getSpeed;

// Methode statistiques
-(double) getUnhappiness;

// Comportement de l'agent.
-step;
-step1;

// Affichage de l'agent a l'ecran.
-drawSelfOn: (Raster *) r;

@end
