// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ModelSwarm.m 

#import "ModelSwarm.h"

@implementation ModelSwarm  

+ createBegin: aZone 
{
  ModelSwarm *obj;
  id <ProbeMap> probeMap;

  // in createBegin, we set up the simulation parameters

  // first, call our superclass createBegin - the return value is the
  // allocated Swarm object.

  obj = [super createBegin: aZone];

  // now fill in simulation parameters with default values.

  obj-> useEO_EP                                   =  0;

// +++++++ start
  obj-> consumerNumber                             =  10;
  obj-> consumerInputNodeNumber                    =  4;
  obj-> consumerHiddenNodeNumber                   =  8;
  obj-> consumerOutputNodeNumber                   =  6;
  obj-> producerNumber                             =  10;
  obj-> producerInputNodeNumber                    =  4;
  obj-> producerHiddenNodeNumber                   =  8;
  obj-> producerOutputNodeNumber                   =  6;
  obj-> agentNumber = obj->consumerNumber + obj->producerNumber;
// +++++++ end

  obj-> patternNumberInVerificationSet     = -1;
  obj-> patternNumberInTrainingSet         = -1;
  obj-> epochNumberInEachTrainingCycle     =  1;
  obj-> agentsAreDisplayingData            =  0;
  obj-> readWeightsFromFile                =  0;
  obj-> epochGroups                        =  0;

  // build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the format of the probe to give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "useEO_EP"            inClass: [self class]]];

// +++++++ start
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "consumerNumber"      inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "producerNumber"      inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "agentNumber"      inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "consumerInputNodeNumber"  inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "consumerHiddenNodeNumber" inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "consumerOutputNodeNumber" inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "producerInputNodeNumber"  inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "producerHiddenNodeNumber" inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "producerOutputNodeNumber" inClass: [self class]]];
// +++++++ end

  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "patternNumberInVerificationSet"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "patternNumberInTrainingSet"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "epochNumberInEachTrainingCycle"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "epochGroups"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "agentsAreDisplayingData"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "readWeightsFromFile"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForMessage:  "openProbeTo:"     inClass: [self class]]];

  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

- createEnd
{
  return [super createEnd];
}


- buildObjects
{
// +++++++ start
  BPCTAgent * aConsumer;
  BPCTAgent * aProducer;
  ConsumerInterface * aConsumerInterface;
  ProducerInterface * aProducerInterface;
// +++++++ end

  DataWarehouse * aDataWarehouse;


  int i;

// +++++++ start
  char * verificationFileName="data.verification", // the name of this file
                                                   // can be kept unchanged
                                                   // also when the file
                                                   // contents are modified
                                                   // or deleting the file
                                                   // is deleted, as in CT
       * trainingFileName    ="data.training",     // (see above)
       * consumerMinmaxFileName      ="consumerMinmax.data", // mandatory, one
                                                             // for each agent
                                                             // of neural type

       * producerMinmaxFileName      ="producerMinmax.data", // (see above)

       * consumerInitValuesFileName  ="consumerInit.val",  // used in CT scheme
                                                           // but not strictly
                                                           // mandatory

       * producerInitValuesFileName  ="producerInit.val";  // (see above)

  // in this model consumerNumber and producerNumber must be equal
     producerNumber=consumerNumber;

     agentNumber=consumerNumber+producerNumber;
// +++++++ end

  // to check whether using Cross Target (CT) option, i.e.  
  //                                  patternNumberInVerificationSet < 0 and
  //                                  patternNumberInTrainingSet < 0

  if (patternNumberInVerificationSet < 0 && patternNumberInTrainingSet < 0)
                            printf("\n\nUsing Cross Target technique!\n\n"); 

  if (patternNumberInVerificationSet < 0 &&
      patternNumberInVerificationSet != -1)
      {
  printf("\n(In this case the patternNumberInVerificationSet must be -1).\n\n"
       );
       exit(0);
      }

  if ((patternNumberInVerificationSet < 0 && patternNumberInTrainingSet > 0) ||
      (patternNumberInVerificationSet > 0 && patternNumberInTrainingSet < 0))
      {
       printf(
  "\n\nCheck the signs of\n\n"
  "patternNumberInVerificationSet and patternNumberInTrainingSet.\n\n");
       exit(0);
      }

  if (patternNumberInVerificationSet == 0 ||
      patternNumberInTrainingSet == 0   )
      {
       printf(
  "\n\nIllegal zero in patternNumberInVerificationSet "
  "or in patternNumberInTrainingSet.\n\n");
       exit(0);
      }

  // here, we create the objects in the model
  
  // here we create an instance of MatrixMult, VectorTransFunc
  // and of RuleMaster-RuleMaker

  matrixMult = [MatrixMult createBegin: self];
  matrixMult = [matrixMult createEnd];

  transFunc = [TransFunc createBegin: self];
  transFunc = [transFunc createEnd];

  vectorTransFunc = [VectorTransFunc createBegin: self];
  vectorTransFunc = [vectorTransFunc setTransFunc: transFunc];
  vectorTransFunc = [vectorTransFunc createEnd];

  // using artificial neural networks, we have here the learning structure
  // (ruleMaker) and the pure forward step (ruleMaster)

  ruleMaker = [BPCTRuleMaker createBegin: self];
  [ruleMaker setMatrixMult: matrixMult];
  [ruleMaker setVectorTransFunc: vectorTransFunc];
  ruleMaker = [ruleMaker createEnd];

  ruleMaster = [BPCTRuleMaster createBegin: self];
  [ruleMaster setRuleMaker: ruleMaker];
  [ruleMaster setMatrixMult: matrixMult];
  [ruleMaster setVectorTransFunc: vectorTransFunc];
  ruleMaster = [ruleMaster createEnd];

  // default backpropagation parameters

  weightRange  =0.3;
  eps          =0.6;
  alpha        =0.0;
  usingRandomOrderInLearning =1;
  longTermLearningInCT_OnlyWithCompleteTrainingSet =1;
  useOutputsAsTargetsInCT_RelearningScheme =0;

  [ObjectLoader load: self fromFileNamed: "bp.setup"];
// +++++++ start
  // we create a tool to shufle the lists
  listShuffler = [ListShuffler createBegin: self];
  listShuffler = [listShuffler createEnd];
// +++++++ end

  // now, we create the agents


// +++++++ start
  agentList = [List create: self]; // the list of consumers and producers
  agentInterfaceList = [List create: self];
                                   // and that of their interfaces

  consumerList  = [List  create: self];

  consumerArray = [Array create: self];
  if(consumerNumber>0)
    [consumerArray setCount: consumerNumber];

  consumerArrayIndex = [consumerArray begin: self];


  producerList  = [List  create: self];

  producerListIndex = [producerList begin: self];

  producerArray = [Array create: self];
  if(producerNumber>0)
    [producerArray setCount: producerNumber];

  producerArrayIndex = [producerArray begin: self];

  agentArray = [Array create: self];
  if(agentNumber>0)
    [agentArray setCount: agentNumber];

  agentArrayIndex = [agentArray begin: self];



  for (i=1;i<=consumerNumber;i++){

  // first we create the datawarehouse where agent technical data ar stored
  aDataWarehouse= [DataWarehouse createBegin: self];
  [aDataWarehouse setVerificationFileName: verificationFileName
                          andTrainingFileName: trainingFileName
                          andMinmaxName: consumerMinmaxFileName
                          andInitValuesFileName: consumerInitValuesFileName];
  [aDataWarehouse setInputNodeNumber:  consumerInputNodeNumber
                  andHiddenNodeNumber: consumerHiddenNodeNumber
                  andOutputNodeNumber: consumerOutputNodeNumber
           andPatternNumberInVerificationSet: patternNumberInVerificationSet
           andPatternNumberInTrainingSet:     patternNumberInTrainingSet
           andEpochNumberInEachTrainingCycle:
                                       epochNumberInEachTrainingCycle];
  [aDataWarehouse setBackPropagationParametersWeightRange: weightRange
                  eps: eps alpha: alpha
                  andWithOrderInLearning: usingRandomOrderInLearning
                  andLongTermLearningInCT:
                  longTermLearningInCT_OnlyWithCompleteTrainingSet
                  andUseOutputsAsTargetsInCT:
                  useOutputsAsTargetsInCT_RelearningScheme];

  aDataWarehouse=[aDataWarehouse createEnd];

  // then we create an interface for our agent, to simplifly its links
  // with the observer, if any, but mainly as a help in CT building

  aConsumerInterface = [ConsumerInterface createBegin: self];
  [aConsumerInterface setUseEO_EP: useEO_EP];
  [aConsumerInterface setAgentNumber: i];
  [aConsumerInterface setDataWarehouse: aDataWarehouse];
  [aConsumerInterface setProducerListIndex: producerListIndex];
  aConsumerInterface = [aConsumerInterface createEnd];
  [aConsumerInterface initialize]; // NB. after createEnd

  aConsumer = [BPCTAgent createBegin: self];
  [aConsumer setNumber: i andSetReadWeightsFromFile: readWeightsFromFile];
  [aConsumer setDataWarehouse: aDataWarehouse];
  [aConsumer setInterface: aConsumerInterface];
  [aConsumer setRuleMaster: ruleMaster];
  [aConsumer setDisplayDataWhileRunning: agentsAreDisplayingData];
  aConsumer = [aConsumer createEnd];

  [agentList addLast:    aConsumer];
  [agentInterfaceList addLast:    aConsumerInterface];
  [consumerList addLast: aConsumer];

  [consumerArrayIndex next];
  [consumerArrayIndex put: aConsumer];

  [agentArrayIndex next];
  [agentArrayIndex put: aConsumer];

   }

  for (i=1;i<=producerNumber;i++){

  // first we create the datawarehouse where agent technical data are stored
  aDataWarehouse= [DataWarehouse createBegin: self];
  [aDataWarehouse setVerificationFileName: verificationFileName
                          andTrainingFileName: trainingFileName
                          andMinmaxName: producerMinmaxFileName
                          andInitValuesFileName: producerInitValuesFileName];
  [aDataWarehouse setInputNodeNumber:  producerInputNodeNumber
                  andHiddenNodeNumber: producerHiddenNodeNumber
                  andOutputNodeNumber: producerOutputNodeNumber
           andPatternNumberInVerificationSet: patternNumberInVerificationSet
           andPatternNumberInTrainingSet:     patternNumberInTrainingSet
           andEpochNumberInEachTrainingCycle:
                                       epochNumberInEachTrainingCycle];
  [aDataWarehouse setBackPropagationParametersWeightRange: weightRange
                  eps: eps alpha: alpha
                  andWithOrderInLearning: usingRandomOrderInLearning
                  andLongTermLearningInCT:
                  longTermLearningInCT_OnlyWithCompleteTrainingSet
                  andUseOutputsAsTargetsInCT:
                  useOutputsAsTargetsInCT_RelearningScheme];

  aDataWarehouse=[aDataWarehouse createEnd];

  // then we create an interface for our agent, to simplifly its links
  // with the observer, if any, but mainly as a help in CT building

  aProducerInterface = [ProducerInterface createBegin: self];
  [aProducerInterface setUseEO_EP: useEO_EP];
  [aProducerInterface setAgentNumber: i+consumerNumber];
  [aProducerInterface setDataWarehouse: aDataWarehouse];
  aProducerInterface = [aProducerInterface createEnd];
  [aProducerInterface initialize]; // NB. after createEnd

  aProducer = [BPCTAgent createBegin: self];
  [aProducer setNumber: i+consumerNumber
                          andSetReadWeightsFromFile: readWeightsFromFile];
  [aProducer setDataWarehouse: aDataWarehouse];
  [aProducer setInterface: aProducerInterface];
  [aProducer setRuleMaster: ruleMaster];
  [aProducer setDisplayDataWhileRunning: agentsAreDisplayingData];
  aProducer = [aProducer createEnd];

  [agentList addLast:    aProducer];
  [agentInterfaceList addLast:    aProducerInterface];
  [producerList addLast: aProducer];

  [producerArrayIndex next];
  [producerArrayIndex put: aProducer];
  [agentArrayIndex next];
  [agentArrayIndex put: aProducer];
// +++++++ end

   }
  return self;
}

- buildActions
{
  // create the list of simulation actions.

  modelActions = [ActionGroup create: self];
// +++++++ start
  [modelActions createActionTo: listShuffler
                                message: M(shuffleWholeList:) : producerList];
  [modelActions createActionTo: producerListIndex
                                message: M(setLoc:) : Start];
  // see agent.h and agent.m to undestand the rigid three step structure
  [modelActions createActionForEach: consumerList    message: M(step1)];
  [modelActions createActionForEach: producerList    message: M(step1)];
  [modelActions createActionForEach: consumerList    message: M(step2)];
  [modelActions createActionForEach: producerList    message: M(step2)];
  [modelActions createActionForEach: consumerList    message: M(step3)];
  [modelActions createActionForEach: producerList    message: M(step3)];
// +++++++ end
  [modelActions createActionTo: self message: M(currentEpochGroups)];

  // then we create a schedule that executes the modelActions.

  modelSchedule = [Schedule createBegin: self];

  // the "if" condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
  [modelSchedule setRepeatInterval: -1*patternNumberInVerificationSet];
  else
  [modelSchedule setRepeatInterval:    patternNumberInVerificationSet];  
                 // the repeat interval is set to the number of steps which is
                 // necessary in the Observer to display the values of each
                 // pattern of an agent in each cycle
                 // here patternNumberInVerificationSet-1 steps are void
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;
}

- activateIn: swarmContext
{
  // here, we activate the swarm in the context passed in
  // then we activate our schedule in ourselves

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];
  
  
  return [self getSwarmActivity];
}

- (int) currentEpochGroups
{
  epochGroups++;
//  printf("Epoch group #%5d\n",epochGroups);
  return epochGroups;
}

- (int) getCurrentEpochGroup
{
  return epochGroups;
}

- (int) getPatternNumberInVerificationSet
{
  return patternNumberInVerificationSet;
}

- (int) getConsumerNumber
{
  return consumerNumber;
}

- (int) getProducerNumber
{
  return producerNumber;
}

- getList
{
  return agentList;
}

- getInterfaceList
{
  return agentInterfaceList;
}

- getConsumerArrayIndex
{
  return consumerArrayIndex;
}

- getProducerArrayIndex
{
  return producerArrayIndex;
}

- openProbeTo: (int) n
{
  BPCTAgent * anAgent;

  if (n<1 || n>agentNumber) return self;

  [agentArrayIndex setOffset: n-1];
  anAgent=[agentArrayIndex get];
  [anAgent getProbe];

  return anAgent;
}

@end
