// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

//Matrix.m                                        

#import "Matrix.h"
#import <stdlib.h> // calloc

@implementation Matrix

// methods are commented in Matrix.h

  // in setting dimensions we check for negative values (may be used in the
  // CT perspective

- setDimensionRows: (int) r Cols: (int) c Code: (int) cod // two dimensions
{                                                   
  firstRow=0;                                  // firstRow is normally 0, but
                                               // if we fill dynamically the
  rows=r;                                      // matrix it starts below the
    if (rows < 0) {rows *= -1; firstRow=rows;} // last row and goes up with
  cols=c;                                      // each shift order
    if (cols < 0) cols *= -1;

  m = (float *) calloc(rows*cols,sizeof(float));

  max=rows*cols;
  code=cod;
  return self;
}
- setDimension: (int) p  Code: (int) cod                 // vector
{
  firstRow=0;

  rows=p;                   // vectors are treated as column vectors
    if (rows < 0){ rows *= -1; firstRow=rows;}

  m = (float *) calloc(rows,sizeof(float));

  cols=1;
  max=rows;
  code=cod;
  return self;  
}

- shift
{
  int i, j;
  firstRow--; if (firstRow < 0) firstRow = 0;

  if(rows==1) return self;

  for (i=1;i<rows;i++)
  for (j=0;j<cols;j++)
  m[(i-1)*cols+j]=m[i*cols+j];

  return self;
}

- (int) getFirstRow
{
  return firstRow;
}


- (float) R: (int) r C: (int) c
{
  if (r >= rows || c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(reading at %d %d)",r,c);
        exit(0);}
  return m[r*cols+c];
}

- (float) P: (int) p
{
  if (p >= max){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(reading at %d)",p);
        exit(0);}
  return m[p];
}

- R: (int) r C: (int) c setFrom: (float) v
{
  if (r >= rows || c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing at %d %d)",r,c);
        exit(0);}
  m[r*cols+c]=v;
  return self;
}

- P: (int) p setFrom: (float) v
{
  if (p >= max){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing at %d)",p);
        exit(0);}
  m[p]=v;
  return self;
}

- R: (int) r C: (int) c setFromP: (float) v
{
  if (r >= rows || c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing at %d %d)",r,c);
        exit(0);}
  m[r*cols+c]+=v;
  return self;
}

- P: (int) p setFromP: (float) v
{
  if (p >= max){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing at %d)",p);
        exit(0);}
  m[p]+=v;
  return self;
}

- (int) getNumberOfElements
{
  return max;
}

- (int) getNumberOfRows
{
  return rows;
}

- (int) getNumberOfCols
{
  return cols;
}

- (float *) getAddress // if necessary ...
{
  return m;
}

- (float *) getAddress1 // if necessary ...
{
  return &m[1];
}

- (float) R: (int) r C: (int) c asExternalValueUsing: mm withShift: (int) sf
{
  if (r >= rows || c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(reading to external at %d %d)",r,c);
        exit(0);}
  return
    ((m[r*cols+c]-[mm R:c+sf C:2])/
                         ([mm R:c+sf C:3]-[mm R:c+sf C:2]) ) *
                         ([mm R:c+sf C:1]-[mm R:c+sf C:0])+[mm R:c+sf C:0];
}

- R: (int) r C: (int) c setFrom: (float) v asExternalValueUsing: mm
                                         withShift: (int) sf
{
  if (r >= rows || c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing from external at %d %d)",r,c);
        exit(0);}
// no control is made about data exceeding min or max limits 
  m[r*cols+c]=
    ((v-[mm R:c+sf C:0])/
                         ([mm R:c+sf C:1]-[mm R:c+sf C:0]) ) *
                         ([mm R:c+sf C:3]-[mm R:c+sf C:2])+[mm R:c+sf C:2];
  return self;
}

- R_lastAndC:    (int) c setFrom: (float) v asExternalValueUsing: mm
                                         withShift: (int) sf
{
  if (c >= cols){
printf("Max dimension exceeded in an instance of Matrix.h (code=%d)\n",code);
printf("(writing from external at %d %d)",rows-1,c);
        exit(0);}
// no control is made about data exceeding min or max limits 
  m[(rows-1)*cols+c]=
    ((v-[mm R:c+sf C:0])/
                         ([mm R:c+sf C:1]-[mm R:c+sf C:0]) ) *
                         ([mm R:c+sf C:3]-[mm R:c+sf C:2])+[mm R:c+sf C:2];
  return self;
}



@end
                                     
