// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// BPCTAgent.h 

#import <objectbase/SwarmObject.h>
#import <simtools.h>  // necessary to invoke OutFile protocol
#import <simtoolsgui/GUISwarm.h> // to use CREATE_ARCHIVED_PROBE_DISPLAY
#import <simtoolsgui.h>          // ""
#import "Matrix.h"
#import "BPCTRuleMaster.h" // the source of the rules that determe the agent
                           // behavior
#import "DataWarehouse.h"
#import "Interface.h" // here we include the general class; the pointer
                      // assigned to the agent in modelSwarm will be related
                      // to a specific interface (SpecificInterface.h in the
                      // general case); the interface changes in the various
                      // applications, but in modelSwarm we use only methods
                      // defined in the Interface parent object

@interface BPCTAgent: SwarmObject
{

  BPCTRuleMaster    * ruleMaster;
  DataWarehouse * myDataWarehouse;
  Interface * myInterface;
  int number, inputNodeNumber, hiddenNodeNumber, outputNodeNumber,
  patternNumberInVerificationSet,
  agentsAreDisplayingData, readWeightsFromFile;
  float backPropagationErrorInVerificationSet,
        proportionalErrorInVerificationSet,
        backPropagationErrorInTrainingSet,
        proportionalErrorInTrainingSet;
  Matrix * outputVerificationMatrix, * targetVerificationMatrix, * minmax;

}

- createEnd;

- setNumber: (int) n andSetReadWeightsFromFile: (int) rw;
- setRuleMaster: rm;
- setDataWarehouse: dw;
- setInterface: inf;
- setDisplayDataWhileRunning: (int) d;

- getDataWarehouse;
- getInterface;
- (int) getNumber;

- step1; // see Agent.m
- step2;
- step3;

-(float) getBackPropagationErrorInVerificationSet;
-(float) getProportionalErrorInVerificationSet;

-(float) getBackPropagationErrorInTrainingSet;
-(float) getProportionalErrorInTrainingSet;

- getProbe;

- save;  // to save the weights

@end



