#import <stdlib.h>
#import <simtools.h>
#import <random.h>
#import "ModelSwarm.h"

@implementation ModelSwarm

+createBegin: (id) aZone {
  ModelSwarm * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->population = 10 ;
  obj->eventRate = 40 ;
  obj->maxK = 3 ;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "population"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "eventRate"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "maxK"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}


-createEnd {

  return [super createEnd];
}

-getTheNet {
  return theNet ;
}

-getEntityList {
  return entityList ;
}

-getRandomEntity {
  return [entityList atOffset: [uniformIntRand getIntegerWithMin: 0
                      withMax: ([entityList getCount] - 1)]
  ] ;
}

-setGraphCanvas: aCanvas {
  graphCanvas = aCanvas ;
  return self ;
}

-buildObjects {
  int i,ii,newK=0;
  id aNode ;
  char * aName;
  
  [super buildObjects];

  theNet = [BoingGraph createBegin: [self getZone]] ;
  [theNet setCanvas: graphCanvas] ;
  [theNet createEnd] ;

  for(i = 0 ; i < population ; i++){
    aName = malloc(10) ;
    sprintf(aName,"Node%d",i) ;
    [theNet addNode: [[[DiGraphNode createBegin: [self getZone]]
                       setNodeLabel: aName ]
                       createEnd]] ;
  }

  entityList = [theNet getNodeList] ;

  for(i = 0 ; i < population ; i++){
    aNode = [entityList atOffset: i] ;

    newK = [uniformIntRand getIntegerWithMin: 1 withMax: maxK] ;
    for(ii = 0 ; ii < newK ; ii++){
        [theNet addLinkFrom: aNode To: [self getRandomEntity]] ;
    }
  }
  
  return self;
}

-buildActions {
  [super buildActions];

  modelActions = [ActionGroup create: [self getZone]];

  [modelActions createActionTo: self message: M(step)] ;

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

-step {
//printf("In ModelSwarm step.\n");
/*
  id newNode ;
  int newK, i ;
printf("In side ModelSwarm step.\n");
  if(![uniformIntRand getIntegerWithMin: 0
                                withMax: eventRate]){
    if([uniformIntRand getIntegerWithMin: 0
                                 withMax: 1]){

      newNode = [[[DiGraphNode createBegin: [self getZone]]
                         setNodeLabel: "Node"]
                         createEnd] ;

      newK = [uniformIntRand getIntegerWithMin: 0 withMax: maxK] ;
      [theNet addNode: newNode] ;
      for(i = 0 ; i < newK ; i++){
        [theNet addLinkFrom: newNode To: [self getRandomEntity]] ;
      }


      
    } else {
      if([entityList getCount]) 
        [theNet dropNode: [self getRandomEntity]] ;
    }
  }
*/
  return self ;
}

@end
