#include <math.h>
#import <random.h>
#import "BoingGraph.h"

#define MAX_EDGES 	        200
#define MAX_NODES 	        200
#define MAX_ITERATIONS	         40
#define DEFAULT_SPRING_LENGTH   100
#define DEFAULT_SPRING_CONST   0.25
#define DEFAULT_REPEL_FACTOR  10000

@implementation BoingGraph

+createBegin: aZone {
  BoingGraph * obj ;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone] ;
//  obj->springLength = DEFAULT_SPRING_LENGTH ;
    obj->springConstant = DEFAULT_SPRING_CONST ;
    obj->repelFactor = DEFAULT_REPEL_FACTOR ;
    
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];


  [probeMap addProbe: [probeLibrary getProbeForVariable: "springLength"
				    inClass: [DiGraph class]]] ;
  [probeMap addProbe: [probeLibrary getProbeForVariable: "springConstant"
				    inClass: [BoingGraph class]]] ;
  [probeMap addProbe: [probeLibrary getProbeForVariable: "repelFactor"
				    inClass: [BoingGraph class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];
  return obj ;
}

/*
-setSpringLength: (float) aLength {
  springLength = aLength ;
  return self ;
}
*/

-setSpringConstant: (float) aNumber {
  springConstant = aNumber ;
  return self ;
}

-setRepelFactor: (float) aFactor {
  repelFactor = aFactor ;
  return self ;
}

-createEnd { 
  [super createEnd] ;
  return self;
}


/*

-redistribute {
  int i, n, h, w, r, x, y, bx, by ;
  double phase ;
  id obj ;

  if(canvas){

    h = [canvas getHeight] ;
    w = [canvas getWidth] ;

    r = ( (h > w) ? w : h ) ;
    r /= 3 ;

    bx = w / 2 ;
    by = h / 2 ;

    n = [nodeList getCount] ;

    for(i = 0 ; i < n ; i++){
      phase = 6.2831853 * ((double) i) / ((double) n) ;
      x = bx + ((int) (((double) r) * cos(phase))) ;
      y = by + ((int) (((double) r) * sin(phase))) ;
      obj = [[nodeList atOffset: i] getNodeItem] ; 
      [obj initiateMoveX: x - [obj getX] Y: y - [obj getY]] ;
    }

  }

  return self ;
}
*/

/*
-boingDistribute {
  return [self boingDistribute: MAX_ITERATIONS] ;
}
*/

/*
-boingDistribute: (int) iterations {
  int i;
  for(i = 0; i < iterations; i++){

// This is the beginnings of an idea on some automatic termination condition:
//   if([self boingStep] < 0.0000000002) i = MAX_ITERATIONS;

    [self boingStep];
  }

  return self;
}
*/


-(double) boingStep {
//
//      This method updates the nodes in
//      a directed graph using 
//      Revised ``Spring Embedding''
//

  int   from[MAX_EDGES];
  int     to[MAX_EDGES];
  double len[MAX_EDGES];

  double nodedx[MAX_NODES];
  double nodedy[MAX_NODES];

  int nedges;

  int i, j, n, h, w, posx, posy;
  double vx, vy, length, length3, f, dx, dy ;
 
  id obj, another_obj ;
  
  for(i = 0; i < MAX_NODES; i++){
    nodedx[i] = 0.0;
    nodedy[i] = 0.0;
  }

  nedges = 0;
  if(canvas){

    h = [canvas getHeight] ;
    w = [canvas getWidth] ;
    n = [nodeList getCount];

//Find the links acting as springs; counting one for each direction.
    for(i = 0; i < n; i++){
                        
      obj = [nodeList atOffset: i];
      for(j = i + 1; j < n; j++){

        another_obj = [nodeList atOffset: j];

        if([obj linkedTo: another_obj] == 1 ){
          from[nedges] = i;
          to[nedges] = j;
          len[nedges] = springLength ;
          nedges++;
        }

        if([obj linkedFrom: another_obj] == 1){
          from[nedges] = j;
          to[nedges] = i;
          len[nedges] = springLength ;
          nedges++;
        }
      }
    }

//Determine the effects of the springs.
    for(i = 0; i < nedges; i++){
      vx = [[[nodeList atOffset: to[i]] getNodeItem] getX] - 
           [[[nodeList atOffset: from[i]] getNodeItem] getX];
      vy = [[[nodeList atOffset: to[i]] getNodeItem] getY] - 
           [[[nodeList atOffset: from[i]] getNodeItem] getY];
      length = pow(vx * vx + vy * vy, 0.5);
      f = (springConstant * (len[i] - length)) / length;
      dx = f * vx;
      dy = f * vy;
      nodedx[to[i]] += dx;
      nodedy[to[i]] += dy;
      nodedx[from[i]] -= dx;
      nodedy[from[i]] -= dy;
    }

//Now accumulate repulsion.
    for(i = 0; i < n; i++){
      obj = [nodeList atOffset: i];
      dx = 0.0;
      dy = 0.0;

      for(j = 0; j < n; j++){
        if(i==j)
                        continue;

          another_obj = [nodeList atOffset: j];

          vx = [[obj getNodeItem] getX] - 
               [[another_obj getNodeItem] getX];
          vy = [[obj getNodeItem] getY] - 
               [[another_obj getNodeItem] getY];

          length3 = pow(vx * vx + vy * vy, 1.5);

          if(length3 == 0.0){
            dx += [uniformDblRand getDoubleWithMin: -1.0 
                   withMax:  1.0];
            dy += [uniformDblRand getDoubleWithMin: -1.0 
                   withMax:  1.0];
          } else {

            dx += vx / (length3) ;
            dy += vy / (length3);

          }
      }

      nodedx[i] += repelFactor * dx;
      nodedy[i] += repelFactor * dy;
    }

//Limit the movement rate, find the movement and keep them inside the canvas.
    for(i = 0; i < n ; i++){

      obj = [nodeList atOffset: i];

      if(nodedx[i] >  5.0) nodedx[i] =  5.0;
      if(nodedx[i] < -5.0) nodedx[i] = -5.0;
      if(nodedy[i] >  5.0) nodedy[i] =  5.0;
      if(nodedy[i] < -5.0) nodedy[i] = -5.0;

      posx = [[obj getNodeItem] getX] + nodedx[i];

      if(posx < 0 + (w / 10.0)) posx = 0 + (w / 10.0);
      if(posx > w - (w / 10.0)) posx = w - (w / 10.0);
 
      posy = [[obj getNodeItem] getY] + nodedy[i];

      if(posy < 0 + (h / 10.0)) posy = 0 + (h / 10.0);
      if(posy > h - (h / 10.0)) posy = h - (h / 10.0);

      dx = posx - [[obj getNodeItem] getX] + 0.5 ;
      dy = posy - [[obj getNodeItem] getY] + 0.5 ;
      [[obj getNodeItem] initiateMoveX: dx
                                     Y: dy ];
 //The graph drifts to the upper left without the ( + 0.5) above.
 //This looks like a round-off error in the determination of pos*, 
 //possibly in the getX, getY??? 
 //or when X and Y are reset after the move ???
 
    }
  }

//Find the average movement.???
  vx = 0.0;

  for(i = 0; i < n; i++){
    vx += nodedx[i];
    vx += nodedy[i];
  }

  vx = vx / (2.0 * n);
  
  return vx;
} // end boingStep

/*
-update {
  if(canvas)
    [globalTkInterp eval: "update idletasks"] ;
  return self ;
}
*/

@end
