// Bug.m					SimpleBug

#import "Bug.h"
#import <simtools.h>
#import <random.h>
#import <space.h>

@implementation Bug

- setWorld: w rankedWorld: r andList: l {

  if(world!=nil) {
     [world putObject: nil atX: xPos Y: yPos];
     [w putObject: self atX: xPos Y: yPos];
  }

  world=w;
  worldSize=[world getSizeX];

  if(list!=nil) {
    [list remove: self];
    [l addLast: self];
  }
  list=l;

  rankedWorld=r;
  
  return self;
}


- setBugColor: (int) c {

  myColor=c;

  return self;
}

- createEnd
{
   [super createEnd];
   numMoves=[uniformIntRand getIntegerWithMin: 0 withMax: 100];
   
   return self;
}

- setX: (int)x Y: (int)y
{
  xPos = x;
  yPos = y;

  return self;
}

- setRank: (int) i andCol: (int) j {

  [rankedWorld putObject: self atX: i Y: j];
  yRank=i;
  xRank=j;
  return self;
}

- step
{
  int newX, newY;

  if([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] > 0.1)
    return self;
     
  newX = xPos + [uniformIntRand getIntegerWithMin: -1 withMax: 1];
  newY = yPos + [uniformIntRand getIntegerWithMin: -1 withMax: 1];

  newX = (newX + worldSize) % worldSize;
  newY = (newY + worldSize) % worldSize;
  
  if ([world getObjectAtX: newX Y: newY] == nil)
    {
      numMoves+=(newX > xPos) ? newX-xPos : xPos-newX;
      numMoves+=(newY > yPos) ? newY-yPos : yPos-newY;
      
      [world putObject: nil atX: xPos Y: yPos];
      xPos = newX;
      yPos = newY;
      [world putObject: self atX: xPos Y: yPos];
    }
  
  return self;
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: xPos Y: yPos Color: myColor];
  return self;
}

- rankSelfOn: (id <Raster>)r
{
  
  [r drawPointX: xRank Y: yRank Color: myColor];
  return self;
}

-(int)getMoves {
  return numMoves;
}

@end

