#import "StringRepresentation.h"
#include <string.h>

@implementation StringRepresentation

static char *str[] = {
"  100000000000001    ",
"  110000000000011  ",
"   1100000000011   ",
"    11000000011    ",
"     110000011     ",
"      1100011      ",
"       11011       ",
"                   ",
"         1         ",
"        1 1        ",
"       1 1 1       ",
"      1 1 1 1      ",
"     1 1 1 1 1     ",
"    1 1 1 1 1 1    ",
"   1 1 1 1 1 1 1   ",
"  1 1 1 1 1 1 1 1  ",
"                   ",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1 1 1 1 1 1 1 1 1 1",
"1111111111111111111"};
static char activeChar = '0';
static int currentX, currentY;

+ (void) resetToChar: (char) aChar
{
  activeChar = aChar;
  currentX = currentY = 0;
}
+ (Position*) getNextPos
{
  char c;

  while (currentY < sizeof(str)/sizeof(char*))
  {
    while ((c = str[currentY][currentX++]) != 0)
      if (c == activeChar)
        return [Position create: scratchZone 
                withX: currentX Y: currentY];

    currentX = 0;
    ++currentY;
  }

  return nil;
}
- (unsigned) getSizeX
{
  int i, max=0;

  for (i=0; i<sizeof(str)/sizeof(char*); i++)
  {
    int len = strlen (str[i]);
    if (len > max) max = len;
  }
  return max;
}

- (unsigned) getSizeY { return sizeof(str)/sizeof(char*); }
