package swarmxml;

import swarmxml.DOMParserWrapper;

import org.w3c.dom.Document;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMParser implements DOMParserWrapper, ErrorHandler {
  boolean errorFlag;

  /** Parser. */
  com.ibm.xml.parsers.RevalidatingDOMParser parser = 
      new com.ibm.xml.parsers.RevalidatingDOMParser ();
  
  /** Default constructor. */
  public DOMParser () {
    parser.setErrorHandler (this);
  }
  
  /** Parses the specified URI and returns the document. */
  public Document parse (String uri) throws Exception {
    errorFlag = true;
    parser.parse (uri);
    return parser.getDocument();
  }

  public void validate () throws Exception {
    errorFlag = true;
    if (parser.validate (parser.getDocument ().getDocumentElement ()) != null)
      throw new Exception ("Validation exception");
    else
      System.out.println ("Validated!");
  }

  //
  // ErrorHandler methods
  //
  
  /** Warning. */
  public void warning(SAXParseException ex) {
    System.err.println("[Warning] "+
                       getLocationString(ex)+": "+
                       ex.getMessage());
  }
  
  /** Error. */
  public void error(SAXParseException ex) {
    if (errorFlag)
      System.err.println ("[Error] "+
                         getLocationString (ex) +": "+
                          ex.getMessage ());
  }
  
  /** Fatal error. */
  public void fatalError(SAXParseException ex) throws SAXException {
    System.err.println("[Fatal Error] "+
                       getLocationString(ex)+": "+
                       ex.getMessage());
    throw ex;
  }

  /** Returns a string of the location. */
  private String getLocationString(SAXParseException ex) {
    StringBuffer str = new StringBuffer();
    
    String systemId = ex.getSystemId();
    if (systemId != null) {
      int index = systemId.lastIndexOf('/');
      if (index != -1) 
        systemId = systemId.substring(index + 1);
      str.append(systemId);
    }
    str.append(':');
    str.append(ex.getLineNumber());
    str.append(':');
    str.append(ex.getColumnNumber());
        
    return str.toString();

  }
}
