(load "swarm.scm")

(initSwarm)

(define (print-current-time)
    (display (string-append "t: " (number->string (getCurrentTime))))
  (newline))
  
(define (make-model swarm)
    (let* ((schedule (make-repeating-schedule swarm 5))
           (stopSchedule (make-schedule swarm))
           (target (object ()
                           ((step) <object> (print-current-time) #!null)
                           ((stop) <object> (terminate) #!null)))
           (stopSelector (selector target 'stop))
           (selector (selector target 'step)))
      (scheduleActionTo schedule 1 target selector)
      (scheduleActionTo schedule 3 target selector) 
      (scheduleActionTo stopSchedule 10 target stopSelector)
      (let ((activity (swarmActivateIn swarm #!null)))
        (scheduleActivateIn schedule swarm)
        (scheduleActivateIn stopSchedule swarm)
        activity)))

(define (run-model)
    (run (make-model (make <swarm.objectbase.SwarmImpl> *globalZone*))))
                        
(run-model)
