// AgentObserverSwarm.h

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <tkobjc.h>
#import <collections.h>
#import <simtools.h>
#import "AgentModelSwarm.h"

#define NB_TO_REACH 1000

@interface AgentObserverSwarm : GUISwarm {
  int displayFrequency;	// one parameter: update freq
  id displayActions; // schedule data structs
  id displaySchedule;
  AgentModelSwarm *agentModelSwarm; // the Swarm we are observing
  XColormap *colormap;	// allocate colours
  ZoomRaster *worldRaster; // 2d display widget
  Value2dDisplay *envDisplay; // display the objects
  Object2dDisplay *agentDisplay; // display the agents
}

+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;
-(int)getDisplayFrequency; 
-checkToStop;

@end
