// AgentModelSwarm.h

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>
#import "AgentCamera.h"
#import "WorldObject.h"
#import <space.h>
#import <activity.h>
#import <collections.h>

@interface AgentModelSwarm : Swarm {
  int numAgents;
  int numAgentCamera;
  int InitNumObjects;  	
  int seedValueObjects;	
  int seedValueLocAgt;  
  int worldXSize, worldYSize;
  int numIterations;
 
  id modelActions; // scheduling data structures
  id modelSchedule;

  id agentList; // list of all the agents
  Grid2d *worldAgent; //  the world, containing the agents
  WorldObject *worldObject; // worldObject contains only the objects
}

-getAgentList; // access methods into the
-(Grid2d *) getWorldAgent; // model swarm. These methods
-(WorldObject *) getWorldObject; // allow the model swarm to be observed.

-IncrementNumIterations;
-(int)getNumIterations;

-addAgent: (id) agt; // special method for demo

+createBegin: (id) aZone;  // extra methods you provide for Swarms
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
