
// AgentCamera.h

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>	 // we inherit swarm objects
#import <tkobjc/Raster.h> // special class for graphics
#import "WorldObject.h" // we also have a WorldObject object
#import <vision/Camera.h>
#import <vision/TwoD.h>

#define PI M_PI
#define TwoPI 2*M_PI
#define PI_4 M_PI/4
#define PI_2 M_PI/2
#define ThreePI_2 3*M_PI/2
#define ThreePI_4 3*M_PI/4
#define FivePI_4 5*M_PI/4
#define SevenPI_4 7*M_PI/4
#define PI_8 M_PI/8


// We inherit code from the generic SwarmObject, which provides memory
// allocation and other niceties.

@interface AgentCamera: SwarmObject {
  int x, y; // my spatial coordinates
  double rotAngle;
  Grid2d *worldAgent; // the world agents live in
  int worldXSize, worldYSize; // how big that world is
  WorldObject *worldObject;// the world containing objects
  Color agtColor; // my colour (display)
  id randGAgt; // my own random generator for displacements
  id uRandAgt;
  int seedValueAgt;
  id pixellist; // list of 2D points
  Camera *camera;
  int nbPointSeen;
}

-setWorlds: (Grid2d *) wAgt: (WorldObject *) wObj; // which world are we in?
-createEnd;
-setX: (int) x Y: (int) y; // agt's position
-setCameraInit;
-setRotAngle: (double)val;
-(double)getRotAngle;
-setNbPointSeen: (int)val;
-(int)getNbPointSeen;
-setSeed: (int)value;

// The major agent behaviour: do one "time step" (all agt action).
-step;

-setAgtColor: (Color) c; // agt's colour (display)

// extra display code (agents currently draw themselves)
-drawSelfOn: (Raster *) r;

@end
