/* A 2d discrete stratified lattice (strattice).
 *
 * Copyright (C) 1996, James J. Clark
 * Centre for Intelligent Machines
 * McGill University
 *
 * A keyed collection (Map) of Grid2d objects (strata).
 * 
 * -allocStratum: aString
 * This method treats the String object passed as a key into the
 * StratticeMap. If an entry already exists matching that key, then
 * that entry is returned. Otherwise a new entry is made and returned.
 *
 */ 

#import <stdlib.h>
#import <space.h>
#import "Strattice.h"

@implementation Strattice

-setSizeX: (int) x Y: (int) y {
  if (xsize)
    [InvalidArgument raiseEvent: "You cannot change the strattice size.\n"];
  xsize = x;
  ysize = y;
  return self;
}

+createBegin: (id) aZone {
  Strattice * obj;
 
  obj = [super createBegin: aZone];
  return obj;
}

-createEnd {
  if (xsize <= 0 || ysize <= 0)
    [InvalidCombination raiseEvent: "invalid size in creation of Strattice\n"];

  StratticeMap = [Map create: [self getZone]]; 
  if(!StratticeMap) return nil; 
  return self;
}

-(Grid2d *)allocStratum: aString {
  Grid2d *stratum;

  stratum = [StratticeMap at: aString]; // see if entry already exists
  if(stratum) return stratum;

  // create the Grid2d to be used as the storage array
  stratum = [Grid2d createBegin: [self getZone]];
  [stratum setSizeX: xsize Y: ysize];
  stratum = [stratum createEnd];

  [StratticeMap at: aString insert: stratum];
  return stratum;
}

@end
