
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "ExampleObject.h"

// This file implements the basic methods needed by any object that will
//  be inserted into a SearchableSpace.

@implementation ExampleObject

+ createBegin: aZone {
  ExampleObject * newExObj;
  newExObj = [super createBegin: aZone];
  
  [newExObj setLocX: 0.0 Y: 0.0];
  [newExObj setVal: 0.0];
  [newExObj setNext: nil];

  return newExObj;
}

- createEnd {

  [super createEnd];
  return self;
}

- setLocX: (double) x Y: (double) y {
  locX = x;
  locY = y;
  return self;
}

- setVal: (double) val {
  value = val;
  return self;
}

- setNext: anObject {
  nextObj = anObject;
  return self;
}

- (double) getDoubleX {
  return locX;
}

- (double) getDoubleY {
  return locY;
}

- (int) getIntX {
  return (int)(locX + 0.5);
}

- (int) getIntY {
  return (int)(locY + 0.5);
}

- (double) getVal {
  return value;
}

- getNext {
  return nextObj;
}

@end
