/**
 * PTHistogram contains three contructors to develop histogram graphs
 * @author  Dario Landini
 */

import swarm.Globals;

import swarm.collections.ListImpl;

import javax.swing.JFrame;

import ptolemy.plot.Histogram;

public class PTHistogram extends Histogram{

public boolean useWarehouses;

private JFrame myFrame = null;

/** The Lists passed through the constructors*/
ListImpl fL;
ListImpl sL;
ListImpl tL;
/** the temporary address of an existing unit */
Unit unit;
/** the temporary address of warehouses, if any */
Warehouse warehouse ;

/**
 * First class constructor
 * @param title the title of the histogram
 * @param xLabel the label on the X axis
 * @param yLabel the label on the Y axis
 * @param xRange the right dimension of the histogram
 * @param xRange the top dimension of the histogram
 * @param firstList a data list
 */
  public PTHistogram(String title, String xLabel, String yLabel, double xRange,
                      double yRange, ListImpl firstList) {

        //create the Frame for the histogram graph
        myFrame = new JFrame();
        //estabilish the title of graph with ptolemy
        setTitle(title);
        //pass the same title to the window's frame
        myFrame.setTitle(title);
        //estabilish the axes' labels with ptolemy
        setXLabel(xLabel);
        setYLabel(yLabel);
        //the lenght of x & y axes
        setXRange(0,xRange);
        setYRange(0,yRange);
        //the right position of bars their widht
        setBinOffset(1);
        setBinWidth(0.5);
        //the legend
        addLegend(0, "Queues in u.");

        fL = firstList;
        //create the "fill" button to resize graph
        setButtons(true);
        //fix the window's dimensions according to x & y range
        int windowWidth = 400;
        int windowHigh = 300;
          if(xRange > 18){
            windowWidth = 700;
          }
          if(xRange<5){
            windowWidth = 300;
          }
        myFrame.setBounds(10,300,windowWidth,windowHigh);

        //add the histogram to the frame
        myFrame.getContentPane().add(this);
        //show the frame
        myFrame.show();
  }

 /**
 * Second class constructor
 * @param title the title of the histogram
 * @param xLabel the label on the X axis
 * @param yLabel the label on the Y axis
 * @param xRange the right dimension of the histogram
 * @param xRange the top dimension of the histogram
 * @param firstList a first data list
 * @param secondList a second data list
 */
  public PTHistogram(String title, String xLabel, String yLabel, double xRange,
                      double yRange, ListImpl firstList, ListImpl secondList) {

        useWarehouses = true; // if we are using this constructor the
	                      // warehouses are activated

        myFrame = new JFrame();
        setTitle(title);
        myFrame.setTitle(title);

        setXLabel(xLabel);
        setYLabel(yLabel);
        setXRange(0,xRange);
        setYRange(0,yRange);

        setBinOffset(1);
        setBinWidth(0.5);

        addLegend(0, "Queues in u.");
        addLegend(1, "Quant. in w.");

        fL = firstList;
        sL = secondList;

        setButtons(true);

        int windowWidth = 400;
        int windowHigh = 300;
          if(xRange > 18){
            windowWidth = 700;
          }
          if(xRange<5){
            windowWidth = 300;
          }
        myFrame.setBounds(10,300,windowWidth,windowHigh);

        myFrame.getContentPane().add(this);
        myFrame.show();
  }

 /**
 * Third class constructor
 * @param title the title of the histogram
 * @param xLabel the label on the X axis
 * @param yLabel the label on the Y axis
 * @param xRange the right dimension of the histogram
 * @param xRange the top dimension of the histogram
 * @param firstList a first data list
 * @param secondList a second data list
 * @param thirdList a third data list
 */

  public PTHistogram(String title, String xLabel, String yLabel, double xRange,
                      double yRange, ListImpl firstList, ListImpl secondList,
                      ListImpl thirdList) {

        myFrame = new JFrame();
        setTitle(title);
        myFrame.setTitle(title);

        setXLabel(xLabel);
        setYLabel(yLabel);
        setXRange(0,xRange);
        setYRange(0,yRange);

        setBinOffset(1);
        setBinWidth(0.5);

        addLegend(0, "Queues in u.");
        addLegend(1, "Quant. in w.");
        addLegend(2, "");

        fL = firstList;
        sL = secondList;
        tL = thirdList;

        setButtons(true);

        int windowWidth = 400;
        int windowHigh = 300;
          if(xRange > 18){
            windowWidth = 700;
          }
          if(xRange<5){
            windowWidth = 300;
          }
        myFrame.setBounds(10,300,windowWidth,windowHigh);

        myFrame.getContentPane().add(this);
        myFrame.show();
  }

  /**
   * this method should be called by the Observer to paint histogram bars,
   * at every schedule. It paints a point for each number contained
   * in the lists of the single object.
   */
  public void addPoints(){
          //it clears graph to repaint it, but it doesn't forget the
          //window instructions
          clear(false);
          //to scroll the first list in all its lenght
          for (int i=0;i<fL.getCount();i++){
              //put in unit the object of the first list imported
              unit = (Unit) fL.atOffset(i);
              //to transform an int into a string
              Integer f = (new Integer (unit.unitNumber));
              String singleLabels = f.toString();
              //add the labels on x axis
              addXTick(singleLabels , i);

                if(unit.getWaitingListLength() != 0){
                    //addPoint in according to the waitingListLength
                    for(int j=0;j<unit.getWaitingListLength();j++){
                        addPoint(0, (double) i);
                    }
                }
          }

          if(useWarehouses){
              //to scroll the second list in all its lenght
              for (int i=0;i<sL.getCount();i++){
                  //put in warehouse the object of the second list imported
                  warehouse = (Warehouse) sL.atOffset(i);
                  if(warehouse.getInventoryCounterValue() != 0){
                      //addPoint in according to the getInventoryCounterValue()
                      for(int j=0;j<warehouse.getInventoryCounterValue();j++){
                          addPoint(1, (double) i);
                      }
                  }
              }
          }
          //repaint the window at each time and execute clear instruction
          repaint();
  }
}
