/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.MessageHandler;
import ptolemy.gui.Query;
import ptolemy.gui.StatusBar;

public abstract class Top
extends JFrame {
    protected static File _directory = null;
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenuItem[] _fileMenuItems = new JMenuItem[]{new JMenuItem("Open File", 79), new JMenuItem("Open URL", 85), new JMenu("New"), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Print", 80), new JMenuItem("Close", 67), new JMenuItem("Exit", 88)};
    protected JMenu _helpMenu = new JMenu("Help");
    protected JMenuItem[] _helpMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72)};
    protected JMenuBar _menubar = new JMenuBar();
    protected StatusBar _statusBar = new StatusBar();
    private File _file = null;
    private String _lastURL = "http://ptolemy.eecs.berkeley.edu/xml/models/";
    private boolean _modified = false;
    private boolean _menuPopulated = false;

    public Top() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Top.this._close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void centerOnScreen() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
    }

    public boolean isModified() {
        return this._modified;
    }

    public void report(Exception ex) {
        this.report("", ex);
    }

    public void report(String message) {
        this._statusBar.setMessage(message);
    }

    public void report(String message, Exception ex) {
        this._statusBar.setMessage("Exception. " + message);
        MessageHandler.error(message, ex);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this._statusBar != null) {
            this._statusBar.setBackground(background);
        }
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    public void pack() {
        if (!this._menuPopulated) {
            this._menuPopulated = true;
            this._fileMenu.setMnemonic(70);
            this._helpMenu.setMnemonic(72);
            this._fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this._fileMenuItems[2].setMnemonic(78);
            this._fileMenuItems[2].setEnabled(false);
            this._fileMenuItems[3].setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this._fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(80, 2));
            if (this instanceof Printable || this instanceof Pageable) {
                this._fileMenuItems[5].setEnabled(true);
            } else {
                this._fileMenuItems[5].setEnabled(false);
            }
            this._fileMenuItems[6].setAccelerator(KeyStroke.getKeyStroke(87, 2));
            FileMenuListener fml = new FileMenuListener();
            int i = 0;
            while (i < this._fileMenuItems.length) {
                this._fileMenuItems[i].setActionCommand(this._fileMenuItems[i].getText());
                this._fileMenuItems[i].addActionListener(fml);
                this._fileMenu.add(this._fileMenuItems[i]);
                ++i;
            }
            this._menubar.add(this._fileMenu);
            HelpMenuListener sml = new HelpMenuListener();
            int i2 = 0;
            while (i2 < this._helpMenuItems.length) {
                this._helpMenuItems[i2].setActionCommand(this._helpMenuItems[i2].getText());
                this._helpMenuItems[i2].addActionListener(sml);
                this._helpMenu.add(this._helpMenuItems[i2]);
                ++i2;
            }
            this._addMenus();
            this._menubar.add(this._helpMenu);
            this.setJMenuBar(this._menubar);
            this.getContentPane().add((Component)this._statusBar, "South");
        }
        super.pack();
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy II " + this.getClass().getName() + "\n" + "By: Claudius Ptolemaeus, ptolemy@eecs.berkeley.edu\n" + "For more information, see\n" + "http://ptolemy.eecs.berkeley.edu/ptolemyII\n\n" + "Copyright (c) 1997-2000, " + "The Regents of the University of California.", "About Ptolemy II", 1);
    }

    protected void _addMenus() {
    }

    protected boolean _clear() {
        return this._queryForSave();
    }

    protected boolean _close() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                this.dispose();
                return true;
            }
            return false;
        }
        this.dispose();
        return true;
    }

    protected void _exit() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected String _getName() {
        if (this._file == null) {
            return "Unnamed";
        }
        return this._file.getName();
    }

    protected void _help() {
        this._about();
    }

    protected void _open() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle("Select a model file.");
        if (_directory != null) {
            fileDialog.setCurrentDirectory(_directory);
        } else {
            String cwd = System.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        int returnVal = fileDialog.showOpenDialog(this);
        if (returnVal == 0) {
            _directory = fileDialog.getCurrentDirectory();
            try {
                File file = fileDialog.getSelectedFile().getCanonicalFile();
                this._read(file.toURL());
            }
            catch (Exception ex) {
                this.report("Error reading input", ex);
            }
        }
    }

    protected void _openURL() {
        Query query = new Query();
        query.setTextWidth(60);
        query.addLine("url", "URL", this._lastURL);
        ComponentDialog dialog = new ComponentDialog((Frame)this, "Open URL", query);
        if (dialog.buttonPressed().equals("OK")) {
            this._lastURL = query.stringValue("url");
            try {
                URL url = new URL(this._lastURL);
                this._read(url);
            }
            catch (Exception ex) {
                this.report("Error reading URL:\n" + this._lastURL, ex);
            }
        }
    }

    protected void _print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this instanceof Pageable) {
            job.setPageable((Pageable)((Object)this));
        } else if (this instanceof Printable) {
            PageFormat format = job.pageDialog(job.defaultPage());
            job.setPrintable((Printable)((Object)this), format);
        } else {
            return;
        }
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                MessageHandler.error("Printing Failed", ex);
            }
        }
    }

    protected abstract void _read(URL var1) throws Exception;

    protected boolean _save() {
        if (this._file != null) {
            try {
                this._writeFile(this._file);
                this.setModified(false);
                return true;
            }
            catch (IOException ex) {
                this.report("Error writing file", ex);
                return false;
            }
        }
        return this._saveAs();
    }

    protected boolean _saveAs() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle("Save as...");
        if (_directory != null) {
            fileDialog.setCurrentDirectory(_directory);
        } else {
            String cwd = System.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        int returnVal = fileDialog.showSaveDialog(this);
        if (returnVal == 0) {
            String query;
            int selected;
            this._file = fileDialog.getSelectedFile();
            if (this._file.exists() && (selected = JOptionPane.showOptionDialog(this, query = "Overwrite " + this._file.getName() + "?", "Save Changes?", 0, 3, null, null, null)) == 1) {
                return false;
            }
            this.setTitle(this._getName());
            _directory = fileDialog.getCurrentDirectory();
            return this._save();
        }
        return false;
    }

    protected abstract void _writeFile(File var1) throws IOException;

    private boolean _queryForSave() {
        Object[] options = new Object[]{"Save", "Discard changes", "Cancel"};
        String query = "Save changes to " + this._getName() + "?";
        int selected = JOptionPane.showOptionDialog(this, query, "Save Changes?", 1, 3, null, options, options[0]);
        if (selected == 0) {
            return this._save();
        }
        return selected == 1;
    }

    class HelpMenuListener
    implements ActionListener {
        HelpMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("About")) {
                Top.this._about();
            } else if (actionCommand.equals("Help")) {
                Top.this._help();
            }
            Top.this.repaint();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("Open File")) {
                Top.this._open();
            } else if (actionCommand.equals("Open URL")) {
                Top.this._openURL();
            } else if (actionCommand.equals("Save")) {
                Top.this._save();
            } else if (actionCommand.equals("SaveAs")) {
                Top.this._saveAs();
            } else if (actionCommand.equals("Print")) {
                Top.this._print();
            } else if (actionCommand.equals("Close")) {
                Top.this._close();
            } else if (actionCommand.equals("Exit")) {
                Top.this._exit();
            }
            Top.this.repaint();
        }
    }
}

