/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ptolemy.gui.QueryListener;

public class Query
extends JPanel {
    public static final int DEFAULT_ENTRY_WIDTH = 20;
    protected Color _background = null;
    protected GridBagLayout _grid;
    protected GridBagConstraints _constraints;
    protected Vector _listeners;
    private Map _entries = new HashMap();
    private JPanel _entryPanel = new JPanel();
    private Map _labels = new HashMap();
    private JTextArea _messageArea = null;
    private JPanel _messagePanel = new JPanel();
    private Map _previous = new HashMap();
    private int _width = 20;

    public Query() {
        this._grid = new GridBagLayout();
        this._constraints = new GridBagConstraints();
        this._constraints.fill = 2;
        this._constraints.weightx = 1.0;
        this._constraints.anchor = 18;
        this._entryPanel.setLayout(this._grid);
        this.setLayout(new BoxLayout(this, 1));
        this._entryPanel.setAlignmentX(0.0f);
        this._messagePanel.setAlignmentX(0.0f);
        this.add(this._messagePanel);
        this.add(this._entryPanel);
        this._entryPanel.setBackground(null);
        this._messagePanel.setBackground(null);
    }

    public void addCheckBox(String name, String label, boolean defaultValue) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        JRadioButton checkbox = new JRadioButton();
        checkbox.setBackground(this._background);
        checkbox.setOpaque(false);
        checkbox.setSelected(defaultValue);
        this._addPair(name, lbl, checkbox, checkbox);
        checkbox.addItemListener(new QueryItemListener(name));
    }

    public void addChoice(String name, String label, String[] values, String defaultChoice) {
        this.addChoice(name, label, values, defaultChoice, false);
    }

    public void addChoice(String name, String label, String[] values, String defaultChoice, boolean editable) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        JComboBox<String> combobox = new JComboBox<String>(values);
        combobox.setEditable(editable);
        combobox.setBackground(Color.white);
        combobox.setSelectedItem(defaultChoice);
        this._addPair(name, lbl, combobox, combobox);
        combobox.addItemListener(new QueryItemListener(name));
    }

    public void addDisplay(String name, String label, String theValue) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        JTextArea displayField = new JTextArea(theValue, 1, 10);
        displayField.setEditable(false);
        displayField.setBackground(this._background);
        this._addPair(name, lbl, displayField, displayField);
    }

    public void addLine(String name, String label, String defaultValue) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        JTextField entryBox = new JTextField(defaultValue, this._width);
        entryBox.setBackground(Color.white);
        this._addPair(name, lbl, entryBox, entryBox);
        entryBox.addActionListener(new QueryActionListener(name));
        entryBox.addFocusListener(new QueryFocusListener(name));
    }

    public void addQueryListener(QueryListener listener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public void addRadioButtons(String name, String label, String[] values, String defaultValue) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        Panel buttonPanel = new Panel(flow);
        ButtonGroup group = new ButtonGroup();
        QueryActionListener listener = new QueryActionListener(name);
        JRadioButton[] buttons = new JRadioButton[values.length];
        int i = 0;
        while (i < values.length) {
            JRadioButton checkbox;
            buttons[i] = checkbox = new JRadioButton(values[i]);
            checkbox.setBackground(this._background);
            checkbox.setOpaque(false);
            if (values[i].equals(defaultValue)) {
                checkbox.setSelected(true);
            }
            group.add(checkbox);
            buttonPanel.add(checkbox);
            checkbox.addActionListener(listener);
            ++i;
        }
        this._addPair(name, lbl, buttonPanel, buttons);
    }

    public void addSelectButtons(String name, String label, String[] values, Set initiallySelected) {
        JLabel lbl = new JLabel(label + ": ");
        lbl.setBackground(this._background);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        Panel buttonPanel = new Panel(flow);
        QueryActionListener listener = new QueryActionListener(name);
        if (initiallySelected == null) {
            initiallySelected = new HashSet();
        }
        JRadioButton[] buttons = new JRadioButton[values.length];
        int i = 0;
        while (i < values.length) {
            JRadioButton checkbox;
            buttons[i] = checkbox = new JRadioButton(values[i]);
            checkbox.setBackground(this._background);
            checkbox.setOpaque(false);
            if (initiallySelected.contains(values[i])) {
                checkbox.setSelected(true);
            }
            buttonPanel.add(checkbox);
            checkbox.addActionListener(listener);
            ++i;
        }
        this._addPair(name, lbl, buttonPanel, buttons);
    }

    public void addSlider(String name, String label, int defaultValue, int minimum, int maximum) throws IllegalArgumentException {
        JLabel lbl = new JLabel(label + ": ");
        if (minimum > maximum) {
            int temp = minimum;
            minimum = maximum;
            maximum = temp;
        }
        if (defaultValue > maximum || defaultValue < minimum) {
            throw new IllegalArgumentException("Desired default value \"" + defaultValue + "\" does not fall " + "between the minimum and maximum.");
        }
        JSlider slider = new JSlider(minimum, maximum, defaultValue);
        this._addPair(name, lbl, slider, slider);
        slider.addChangeListener(new SliderListener(name));
    }

    public boolean booleanValue(String name) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + "\" in the query box.");
        }
        if (result instanceof JRadioButton) {
            return ((JRadioButton)result).isSelected();
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a radio button, and hence does not have " + "a boolean value.");
    }

    public double doubleValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            return new Double(((JTextField)result).getText());
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a text line, and hence cannot be converted to " + "a double value.");
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int getTextWidth() {
        return this._width;
    }

    public int intValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            return new Integer(((JTextField)result).getText());
        }
        if (result instanceof JSlider) {
            return ((JSlider)result).getValue();
        }
        if (result instanceof JComboBox) {
            return ((JComboBox)result).getSelectedIndex();
        }
        if (result instanceof JRadioButton[]) {
            JRadioButton[] buttons = (JRadioButton[])result;
            int i = 0;
            while (i < buttons.length) {
                if (buttons[i].isSelected()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a text line or slider, and hence " + "cannot be converted to " + "an integer value.");
    }

    public void notifyListeners() {
        Iterator names = this._entries.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            this._notifyListeners(name);
        }
    }

    public void removeQueryListener(QueryListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public void set(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            ((JTextField)result).setText(value);
        } else if (result instanceof JTextArea) {
            ((JTextArea)result).setText(value);
        } else if (result instanceof JRadioButton) {
            Boolean flag = new Boolean(value);
            this.setBoolean(name, flag);
        } else if (result instanceof JSlider) {
            Integer parsed = new Integer(value);
            ((JSlider)result).setValue(parsed);
        } else if (result instanceof JComboBox) {
            ((JComboBox)result).setSelectedItem(value);
        } else if (result instanceof JRadioButton[]) {
            HashSet<String> selectedValues = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                selectedValues.add(tokenizer.nextToken().trim());
            }
            JRadioButton[] buttons = (JRadioButton[])result;
            int i = 0;
            while (i < buttons.length) {
                if (selectedValues.contains(buttons[i].getText())) {
                    buttons[i].setSelected(true);
                } else {
                    buttons[i].setSelected(false);
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Query class cannot set a string representation for entries of type " + result.getClass());
        }
        this._previous.put(name, value);
    }

    public void setAndNotify(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        this.set(name, value);
        this._notifyListeners(name);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._background = color;
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (!(components[i] instanceof JTextField)) {
                components[i].setBackground(this._background);
            }
            ++i;
        }
    }

    public void setBoolean(String name, boolean value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + "\" in the query box.");
        }
        if (!(result instanceof JRadioButton)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a radio button, and hence does not have " + "a boolean value.");
        }
        ((JRadioButton)result).setSelected(value);
        this._notifyListeners(name);
    }

    public void setDisplay(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JTextArea)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a display, and hence cannot be set using " + "setDisplay().");
        }
        JTextArea label = (JTextArea)result;
        label.setText(value);
        this._notifyListeners(name);
    }

    public void setEnabled(String name, boolean value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JComponent) {
            ((JComponent)result).setEnabled(value);
        } else if (result instanceof JRadioButton[]) {
            JRadioButton[] buttons = (JRadioButton[])result;
            int i = 0;
            while (i < buttons.length) {
                buttons[i].setEnabled(value);
                ++i;
            }
        }
    }

    public void setLine(String name, String value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JTextField)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a line, and hence cannot be set using " + "setLine().");
        }
        JTextField line = (JTextField)result;
        line.setText(value);
        this._notifyListeners(name);
    }

    public void setMessage(String message) {
        if (this._messageArea == null) {
            this._messageArea = new JTextArea(message);
            this._messageArea.setFont(new Font("SansSerif", 0, 12));
            this._messageArea.setEditable(false);
            this._messageArea.setLineWrap(true);
            this._messageArea.setWrapStyleWord(true);
            this._messageArea.setBackground(this.getBackground());
            this._messageArea.setAlignmentX(0.0f);
            this._messagePanel.setLayout(new BoxLayout(this._messagePanel, 1));
            this._messagePanel.add(this._messageArea);
            this._messagePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        } else {
            this._messageArea.setText(message);
        }
        this.validate();
    }

    public void setSlider(String name, int value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JSlider)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a slider, and hence cannot be set using " + "setSlider().");
        }
        JSlider theSlider = (JSlider)result;
        theSlider.setValue(value);
        this._notifyListeners(name);
    }

    public void setTextWidth(int characters) {
        this._width = characters;
    }

    public void setToolTip(String name, String tip) {
        JLabel label = (JLabel)this._labels.get(name);
        if (label != null) {
            label.setToolTipText(tip);
        }
    }

    public String stringValue(String name) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            return ((JTextField)result).getText();
        }
        if (result instanceof JTextArea) {
            return ((JTextArea)result).getText();
        }
        if (result instanceof JRadioButton) {
            JRadioButton radioButton = (JRadioButton)result;
            if (radioButton.isSelected()) {
                return "true";
            }
            return "false";
        }
        if (result instanceof JSlider) {
            return "" + ((JSlider)result).getValue();
        }
        if (result instanceof JComboBox) {
            return (String)((JComboBox)result).getSelectedItem();
        }
        if (result instanceof JRadioButton[]) {
            JRadioButton[] buttons = (JRadioButton[])result;
            String toReturn = null;
            int i = 0;
            while (i < buttons.length) {
                if (buttons[i].isSelected()) {
                    toReturn = toReturn == null ? buttons[i].getText() : toReturn + ", " + buttons[i].getText();
                }
                ++i;
            }
            if (toReturn == null) {
                toReturn = "";
            }
            return toReturn;
        }
        throw new IllegalArgumentException("Query class cannot generate a string representation for entries of type " + result.getClass());
    }

    protected void _addPair(String name, JLabel label, Component widget, Object entry) {
        this._constraints.gridwidth = 1;
        this._grid.setConstraints(label, this._constraints);
        this._entryPanel.add(label);
        this._constraints.gridwidth = 0;
        this._grid.setConstraints(widget, this._constraints);
        this._entryPanel.add(widget);
        this._entries.put(name, entry);
        this._labels.put(name, label);
        this._previous.put(name, this.stringValue(name));
    }

    void _notifyListeners(String name) {
        if (this._listeners != null) {
            String previous = (String)this._previous.get(name);
            String newValue = this.stringValue(name);
            if (newValue.equals(previous)) {
                return;
            }
            this._previous.put(name, newValue);
            Enumeration listeners = this._listeners.elements();
            while (listeners.hasMoreElements()) {
                QueryListener queryListener = (QueryListener)listeners.nextElement();
                queryListener.changed(name);
            }
        }
    }

    class SliderListener
    implements ChangeListener {
        private String _name;

        public SliderListener(String name) {
            this._name = name;
        }

        public void stateChanged(ChangeEvent event) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryItemListener
    implements ItemListener {
        private String _name;

        public QueryItemListener(String name) {
            this._name = name;
        }

        public void itemStateChanged(ItemEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryFocusListener
    implements FocusListener {
        private String _name;

        public QueryFocusListener(String name) {
            this._name = name;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryActionListener
    implements ActionListener {
        private String _name;

        public QueryActionListener(String name) {
            this._name = name;
        }

        public void actionPerformed(ActionEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }
}

