/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.gui.CancelException;
import ptolemy.gui.MessageHandler;

public class GraphicalMessageHandler
extends MessageHandler {
    protected static Component _context = null;

    public static void setContext(Component context) {
        _context = context;
    }

    protected void _error(String info) {
        Object[] message = new Object[1];
        String string = info;
        message[0] = this._ellipsis(string, 400);
        Object[] options = new Object[]{"Dismiss"};
        int selected = JOptionPane.showOptionDialog(_context, message, "Error", 0, 0, null, options, options[0]);
    }

    protected void _error(String info, Exception exception) {
        if (exception instanceof CancelException) {
            return;
        }
        Object[] message = new Object[1];
        String string = info != null ? info + "\n" + exception.getMessage() : exception.getMessage();
        message[0] = this._ellipsis(string, 400);
        Object[] options = new Object[]{"Dismiss", "Display Stack Trace"};
        int selected = JOptionPane.showOptionDialog(_context, message, "Exception", 0, 0, null, options, options[0]);
        if (selected == 1) {
            this._showStackTrace(exception, info);
        }
    }

    protected void _message(String info) {
        Object[] message = new Object[]{info};
        Object[] options = new Object[]{"OK"};
        int selected = JOptionPane.showOptionDialog(_context, message, "Message", 0, 1, null, options, options[0]);
    }

    protected void _warning(String info) throws CancelException {
        Object[] message = new Object[]{info};
        Object[] options = new Object[]{"OK", "Cancel"};
        int selected = JOptionPane.showOptionDialog(_context, message, "Warning", 0, 2, null, options, options[0]);
        if (selected == 1) {
            throw new CancelException();
        }
    }

    protected void _warning(String info, Exception exception) throws CancelException {
        Object[] message = new Object[]{info};
        Object[] options = new Object[]{"OK", "Display Stack Trace", "Cancel"};
        int selected = JOptionPane.showOptionDialog(_context, message, "Warning", 0, 2, null, options, options[0]);
        if (selected == 1) {
            this._showStackTrace(exception, info);
        } else if (selected == 2) {
            throw new CancelException();
        }
    }

    private String _ellipsis(String string, int length) {
        if (string.length() > length) {
            return string.substring(0, length - 3) + "...";
        }
        return string;
    }

    private void _showStackTrace(Exception exception, String info) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        JTextArea text = new JTextArea(sw.toString(), 60, 80);
        JScrollPane stext = new JScrollPane(text);
        stext.setPreferredSize(new Dimension(600, 300));
        text.setCaretPosition(0);
        text.setEditable(false);
        Object[] message = new Object[2];
        String string = info != null ? info + "\n" + exception.getMessage() : exception.getMessage();
        message[0] = this._ellipsis(string, 400);
        message[1] = stext;
        JOptionPane.showMessageDialog(_context, message, "Stack trace", 0);
    }
}

