#import <math.h>
#import <stdio.h>

#import "Vector.h"

#define VLENSQRD(a, b) ((a)*(a) + (b)*(b))
#define VLEN(a, b) sqrt(VLENSQRD(a, b))

@implementation Vector


+ (Vector *)create: aZone
{
  Vector *obj = [super create: aZone];
  obj->x = 0.0;
  obj->y = 0.0;
  return obj;
}

- (id <Vector>)init
{
  x = 0.0;
  y = 0.0;
  return self;
}

- (id <Vector>)init: (id <Vector>)v
{
  if (v) {
    x = [v getX];
    y = [v getY];
  } else
    [self init];
  return self;
}

- (id <Vector>)init: (double) x0: (double) y0
{
  x = x0;
  y = y0;
  return self;
}

- (id <Vector>)add: (id <Vector>)v
{
  if (v) {
    x += [v getX];
    y += [v getY];
  }
  return self;
}

- (id <Vector>)sub: (id <Vector>)v
{
  if (v) {
    x -= [v getX];
    y -= [v getY];
  }
  return self;
}

- (id <Vector>)div: (double) d;
{
  if (d != 0) {
    x /= d;
    y /= d;
  }
  return self;
}

- (id <Vector>)mult: (double) d;
{
  x *= d;
  y *= d;
  return self;
}
- (id <Vector>)neg
{
  x *= -1.0;
  y *= -1.0;
  return self;
}
- (id <Vector>)right
{
  double tmp;
  tmp = y;
  y = -1.0 * x;
  x = tmp;
  return self;
}

- (id <Vector>)left
{
  double tmp;
  tmp = x;
  x = -1.0 * y;
  y = tmp;
  return self;
}

- (double) getLength
{
  return sqrt( x*x + y*y );
}

- (id <Vector>)normalize
{
  return [self div: VLEN(x, y)];
}

- (id <Vector>)setLength: (double) l
{
  return [[self normalize] mult: l];
}

- (id <Vector>)setDirection: (id <Vector>)v
{
  double l = [self getLength];
  return [[self init: v] setLength: l];
}

- (int) eq: (id <Vector>)v
{
  if (v)
    return (x == [v getX] && y == [v getY]);
  else
    return 0;
}

- (id <Vector>)cross: (id <Vector>)v
{
  double xx, yy;
  if (v) {
    xx = y*[v getX] - x*[v getY];
    yy = x*[v getY] - y*[v getX];

    x = xx;
    y = yy;
  }
  return self;
}

- (double) dot: (id <Vector>)v
{
  if (v)
    return (x * [v getX] + y * [v getY]);
  return 0.0;
}

- (id <Vector>)print
{
  printf("(%4.6f, %4.6f)\n", x, y);
  return self;
}

- (double) angle: (id <Vector>)v
{
  // returns angle between self and v in RADIANS
  return acos(([self dot: v])/([self getLength]*[v getLength]));
} 

- (double) getX { return x;};
- (double) getY { return y;};
- (id <Vector>) setX: (double) xx { x = xx; return self; }
- (id <Vector>) setY: (double) yy { y = yy; return self; }

