// SimObject.h
//
// A simulation object is a N-dimensional sphere with
// a position and a velocity in N-space and a radius.
// N is defined by the Vector class, and is either 2 or 3

#import <objectbase/SwarmObject.h>
#import "Vector.h"
#import "ModelSwarm.h"
#import "Polygon.h"
#define bool int
#define TRUE 1
#define FALSE 0

typedef enum {
  PREY,
  PREDATOR,
  OBSTACLE
} SimObjectTypes;

#define NUMBOIDTYPES 2
#define NUMOBJECTTYPES 3

@interface SimObject: SwarmObject
{
  ModelSwarm *model;   // the object to ask for global things
  id <Vector> oldPosition;
  id <Vector> calculation;  // for temporary vector calculations
  id <Polygon> display;
  int worldX, worldY;


@public
  int objectID;
  int objectType;
  id <Vector> position;
  id <Vector> velocity;
  double radius;
}

+ (SimObject *) createBegin: aZone;
- createEnd;
- (void) drop;

- init: (int) id : (int) type;
- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v
      : (double  ) r;
- initModel: m;

- setVelocity: (id <Vector>)v;
- setPosition: (id <Vector>)v;
- setRadius: (double) r;

- (id <Vector>)getPosition;
- (id <Vector>)getVelocity;
- (double) getRadius;
- (int) getObjectType;
- (int) getObjectID;
  
- step;
  
- (double) avoid: (id <Vector>)pos with: (id <Vector>) aVector; // returns distance to pos

- createDisplay;
- display;

- drawSelfOn: aRaster;

@end
