#import "Highway.h"
#import <random.h>
#import "Car.h"

@implementation Highway

//---------------------------
+ createBegin: aZone
{
	Highway *obj = [super createBegin: aZone];
	obj->myCars = [List create: aZone];
	return obj;
}

- createEnd
{
	return [super createEnd];
}

- buildObjects
{
	int i;
	id zone = [self getZone];

	for (i=0; i<myDensity*mySize; i++)
	{
		id car;
		int X;
		
		do X = [uniformIntRand getIntegerWithMin: 0 withMax: mySize-1];
		while ([world getObjectAtX: X Y: myY] != nil);
		
		car = [Car createBegin: zone];
		[car setX: X Y: myY];
		[car setV: [uniformIntRand getIntegerWithMin: 1 withMax: myVMax]];
		[car setWorld: world];
		[car setVMax: myVMax pDecel: myP];
		car = [car createEnd];
		[world putObject: car atX: X Y: myY];
		[myCars addFirst: car];
	}
	return self;
}

- buildActions
{
	return self;
}

- activateIn: swarmContext
{
	return self;
}

-(void)setDensity: (float) c vMax: (int) vm P: (float) p
{
	myDensity = c;
	myVMax = vm;
	myP = p;
}

-(void)setWorld: aWorld
{
	world = aWorld;
}

-(void)setY: (int) anY size: (int) aSize
{
	myY = anY;
	mySize = aSize;
}

-(void) step
{
	[myCars forEach: M(accelerate)];
	[myCars forEach: M(brake)];
	[myCars forEach: M(randomize)];
	[myCars forEach: M(drive)];
}

@end
