#import "Car.h"
#import <tkobjc/Raster.h>
#import <space.h>
#import <random.h>

@implementation Car
//----------------------
+createBegin: aZone
{
	return [super createBegin: aZone];
}

-createEnd
{
	return [super createEnd];
}

//----------------------
-(void)setWorld: aWorld
{
	myWorld = aWorld;
	myWorldSize = [myWorld getSizeX];
}

-setX: (int) anX Y: (int) anY
{
	myX = anX;
	myY = anY;
	return self;
}

-(void)setV: (int) vel
{
	myV = vel;
}

-(void)setVMax: (int) vmax pDecel: (float) p
{
	myVMax = vmax;
	myPDecel = p;
}

//---------------------
-(void)accelerate
{
	if (myV < myVMax) ++myV;
}

-(void)brake
{
	int x,v;
	
	if (myV == 0) return;

	x = myX;
	v = 0;
	while (++v <= myV)
	{
		if (++x >= myWorldSize) x=0;
		if ([myWorld getObjectAtX: x Y: myY] != nil)
		{
			myV = v-1;
			return;
		}
	}
}

-(void)randomize
{
	if (myV > 0
		&& [uniformIntRand getIntegerWithMin: 1 withMax: 100] <= myPDecel*100)
		--myV;
}

-(void)drive
{
	int newX = myX + myV;
	if (newX >= myWorldSize) newX -= myWorldSize;
	[myWorld putObject: nil atX: myX Y: myY];
	[myWorld putObject: self atX: newX Y: myY];
	myX = newX;
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: myX Y: myY Color: myColor];

  return self;
}


