// File: MultiObject2dDisplay.m
// 07-97

#import <simtools.h>
#import "MultiObject2dDisplay.h"

@implementation MultiObject2dDisplay

-setDiscrete2dToDisplay: (Discrete2d *) c
{
  MultiDiscrete2d * test2d;
  discrete2d = c;
  test2d = [MultiDiscrete2d createBegin: [self getZone]];
  [test2d setSizeX: 1 Y: 1]; 
  test2d = [test2d createEnd];
  if ([discrete2d getClass] == [test2d getClass])
    isMulti = YES;
  else
    isMulti = NO;
  return self;
}

-createEnd
{
  if (isMulti) // Do not check for display SEL.
  {
    if (displayWidget == nil || discrete2d == nil)
      [InvalidCombination raiseEvent: "Multi-Object display improperly initialized\n"];
  }
  else
    [super createEnd];
  return self;
}

-display: (int) minC : (int) maxC
{
  int x, y, t;
  id * lattice;
  long * offsets;
  int xsize, ysize;

  lattice = [discrete2d getLattice];
  offsets = [discrete2d getOffsets];
  xsize   = [discrete2d getSizeX];
  ysize   = [discrete2d getSizeY];

  if (objectCollection != nil)
    [objectCollection forEach: displayMessage : displayWidget];
  else 
  {
    id testList;
    testList = [List create: [self getZone]];
    for (y = 0; y < ysize; y++)
      for (x = 0; x < xsize; x++)
      {
	id potentialObjList;
	potentialObjList = *discrete2dSiteAt(lattice, offsets, x, y);
	if (potentialObjList != nil)
	  if ([potentialObjList getClass] == [testList getClass])
	  {
	    t = minC + [potentialObjList getCount] - 1;
	    if (t>maxC) t = maxC;
	    [displayWidget drawPointX: x Y: y Color: t];
	  }
	  else
	    [displayWidget drawPointX: x Y: y Color: minC];
      }
  }
  return self;
}

@end
