// Agent.m
// iterated prisoners delemma agent

#import "Agent.h"
#import "gameworld.h"
#import <stdio.h>

// class variables

@implementation Agent

+ createBegin: aZone;
{
  obj=[super createBegin:aZone];

  obj->payoff[0] = 1;
  obj->payoff[1] = 5;
  obj->payoff[2] = 0;
  obj->payoff[3] = 3;
  obj->history = MASK32;
  obj->score = obj->average = obj->reg1 = obj->reg2 = 0;
  
  return self;
}

-setWorld: (Grid2d *) w X: (int) sidex Y: (int) sidey
{
  world = w;
  worldSizeX = sidex;
  worldSizeY = sidey;

  return self;
}

// set own internal coordinates and then place self in world
-setX: (int) inx Y: (int) iny
{
  x = inx;
  y = iny;
  ident = y * worldSizeY + x;
  [world putObject: self atX: x Y: y];

  return self;
}
 
// set agent states

-setID: (int) newid
{
  ident = newid;

  return self;
}

-setPayoff: (int) place Val: (int) value
{
  payoff[place] = value;
  return self;
}

-setMemory: (char) mem
{
  memory = mem;

  return self;
}

-setStrategy: (unsigned) strat
{
  strategy = strat;

  return self;
}

-setHistory: (int) hist
{
  history = hist;

  return self;
}

-setAverage: (double) avg
{
  average = avg;

  return self;
}

-setReg1: (int) info
{
  reg1 = info;

  return self;
}

-setReg2: (double) info
{
  reg2 = info;

  return self;
}

-setGene: (unsigned) gene
{
  [self setStrategy: gene];

  return self;
}

-setGeneLength: (int) length
{
  int count=0;
  while (length>1) {length/=2; count++;}

  [self setMemory: count];

  return self;
}

-copyAgent: (id) a2
{
  [self setMemory: [a2 getMemory]];
  [self setStrategy: [a2 getStrategy]];

  return self;
}

// agent interaction with world

-(char) action
{
  int i,j;

  i = (1 << memory) - 1;				  // mask for past actions
  j = (1 << (i - (history & i))) & strategy;
    
  return ( j != 0 );
}

-updateAgent: (char) action
{
  history = (history << 2) | action;
  score += payoff[(int)action];

  return self;
}

-updateAverage: (int) iter
{
  average += (double) score / iter;
  score = 0;
  
  return self;
}

// get agent state

-(int) getID
{
  return (ident);}

-(char) getMemory
{
  return (memory);
}

-(unsigned) getStrategy
{
  return (strategy);
}

-(int) getScore
{
  return (score);
}

-(double) getAverage
{
  return (average);
}

-(int) getReg1
{
  return (reg1);
}

-(double) getReg2
{
  return (reg2);
}

-(unsigned) getGene
{
  return ([self getStrategy]);
}

-(int) getGeneLength
{
  return (1 << [self getMemory]);
}

// utilities

-iSetKey: (unsigned) inum
{
  ikey = inum;

  return self;
}

-dSetKey: (double) dnum
{
  dkey = dnum;

  return self;
}

-(unsigned) iGetKey
{
  return (ikey);
}

-(double) dGetKey
{
  return (dkey);
}

-debugState
{
  printf("AGENT:%3d ",ident);
  printf("Mem:0x%x Strat:0x%x ",memory,strategy);
  printf("Hist 0x%x Score %3d Avg %g\n",history,score,average);

  return self;
}  

-printState
{
  printf("AGENT:%3d ",ident);
  printf("Memory:0x%x Strategy:0x%x Average:%g\n",memory,strategy,average);

  return self;
}

@end



