#import "Value1dDisplay.h"
// this should be subclassed to fill in the colormap for your CA.
// for now, we expect your colormap to be allocated already.

@implementation Value1dDisplay

-createEnd {
  [super createEnd];

  if (displayWidget == nil || discrete1d == nil)
    [InvalidCombination raiseEvent: "Value display improperly initialized\n"];
  
  if (modFactor == 0)
    modFactor = 1;

  return self;
}

-setDisplayWidget: (Raster *) r Colormap: (XColormap *) c {
  displayWidget = r;
  colormap = c;
  drawPointImp = [r methodFor: @selector(drawPointX:Y:Color:)];
  return self;
}

-setDiscrete1dToDisplay: (Discrete2d *) c {
  discrete1d = c;
  return self;
}

// linear transform between values and colours. Good enough?
-setDisplayMappingM: (int) m C: (int) c {
  modFactor = m;
  colorConstant = c;
  return self;
}

-display: (int) y {
  int x;
  id * lattice;
  int xsize;

  lattice = [discrete1d getLattice];
  xsize = [discrete1d getSizeX];

    for (x = 0; x < xsize; x++) {
      int color;
      color = (int) *(discrete1dSiteAt(lattice, x));
      color = color/modFactor + colorConstant;
      if (color < 0 || color > 255) {
	[WarningMessage raiseEvent: "Value2dDisplay: found colour %d not in [0,255].\n", color];
      }

#ifdef METHODS
      [displayWidget drawPointX: x Y: y Color: (unsigned char)color];
#else
      // cache method lookup.
      (void) *drawPointImp(displayWidget, @selector(drawPointX:Y:Color:),x,y,color);
#endif
    }
  return self;
}

@end
