#define __USE_FIXED_PROTOTYPES__ // for gcc headers

#import <stdlib.h>
#import "Discrete1d.h"
#import <string.h>

// Note - this code assumes that ints can be written in where ids have been
// allocated. It uses casts to do this, and I think is portable to all
// modern architectures.

@implementation Discrete1d

-setSizeX: (int) x {
  if (lattice)
    [InvalidArgument raiseEvent: "You cannot reset the grid size after creation.\n"];
  xsize = x;
  return self;
}

-createEnd {
  if (xsize <= 0)
    [InvalidCombination raiseEvent: "invalid size in creation of Discrete1d\n"];
  lattice = [self allocLattice];

  return self;
}

-(id *) allocLattice {
  void * p;
  p = [[self getZone] alloc: xsize * sizeof(id)];
  memset(p, 0, xsize * sizeof (id));
  return p;
}

-(int) getSizeX {
  return xsize;
}

-getObjectAtX: (int) x {
  return *discrete1dSiteAt(lattice, x);
}

-(int) getValueAtX: (int) x {
  return (int) *discrete1dSiteAt(lattice, x);
}

-putObject: anObject atX: (int) x {
  *discrete1dSiteAt(lattice, x) = anObject;
  return self;
}

-putValue: (int) v atX: (int) x {
  *discrete1dSiteAt(lattice, x) = (id) v;
  return self;
}

-(id *) getLattice {
  return lattice;
}

-fastFillWithValue: (int) aValue {
  int i;
  int lcount = xsize;

  for (i = 0; i < lcount; i++)
    lattice[i] = (id) aValue;

  return self;
}

-fastFillWithObject: anObj {
  int i;
  int lcount = xsize;

  for (i = 0; i < lcount; i++)
    lattice[i] = anObj;

  return self;
}

-fillWithValue: (int) aValue {
  unsigned x;

  for (x = 0; x < xsize; x++)
    [self putValue: aValue atX: x];

  return self;
}

-fillWithObject: anObj {
  unsigned x;

  for (x = 0; x < xsize; x++)
    [self putObject: anObj atX: x];
  
  return self;
}

@end
