// Generic support for 1d discrete lattices.
// Each point in the lattice stores either an id or a integer.
// Ie: 32 bits per point. This is not 100% general, but is the best
// compromise I know of.

// See FUTURE-DESIGN for notes on where this is going.

#import <swarmobject.h>

@interface Discrete1d: SwarmObject {
@public
  int xsize;
  id * lattice;
}

-setSizeX: (int) x;
-createEnd;
-(id *)allocLattice;

-(int) getSizeX;

-getObjectAtX: (int) x;
-(int) getValueAtX: (int) x;

-putObject: anObject atX: (int) x;
-putValue: (int) v atX: (int) x;

-(id *) getLattice;

-fastFillWithValue: (int) aValue;
-fastFillWithObject: anObj;

-fillWithValue: (int) aValue;
-fillWithObject: anObj;

@end

// fast macro to access lattice array. Use this cautiously.
// We define this here to allow library authors to get around the
// getFooAtX: and setFooAtX: methods. This plays havoc with
// inheritance, of course.
#define discrete1dSiteAt(l, x) ((l) + (x))
