// RuleMaker.h
// 
//  GM 0.21 - by Gianluigi Ferraris last update on 6.11.1999
//
//--------------------------------------------------------------------

#import <objectbase/SwarmObject.h>
#import <collections.h>   //needed to handle lists
#import <random.h>        //to perform random values generation
#import "Macro.h"         //shows working options
#import "Trace.h"         //for debug and control about work
#import "Interface.h"     //usually objects that will be asked
#import "Embryo.h"        //New individuals
//#import "Agent.h"       //To allow comunication directly with agents remove
                          //remarks before previous line

@interface RuleMaker: SwarmObject

//--------------------------------------------------------------------

{

AGENT(Agent     * anAgent;)

   Interface * anInterface;
   id <List>   workList,embryoList,parentList,dyingList,populationList;
   float       fitness,totalFitness,minFitness;
   float       turnoverRate,crossoverRate,mutationRate,useDeltaFitness,
               evolutionFrequency,childrenFitness;
   int         lengthOfGenoma,numberOfParents,numberOfIndividuals,
               freeEmbryo,nextEmbryo,
               evolutions,reproductions,crossovers,mutations,nullSteps;

}

//--------------------------------------------------------------------
//Methods to handle set up and modification of parameters

- setLengthOfGenoma:     (int)   gL;
- setTurnoverRate:       (float) tR;
- setCrossoverRate:      (float) cR;
- setMutationRate:       (float) mR;
- setEvolutionFrequency: (float) eF;
- setChildrenFitness:    (float) cF;
- setUseDeltaFitness:    (float) dF;
- setPopulationList:             pL;

- createEnd;

//Methods to give or print statistics

- (int) getEvolutions;
- (int) getReproductions;
- (int) getCrossovers;
- (int) getMutations;
- (int) getNullSteps;
- printStatistics;

//main method: step perform genetic manipulation using service methods

- step;

//--------------------------------------------------------------------

//service methods

- (int) verify;       //frequency verifying
- keepData;           //house keeping
- selectBestN : (int) n fromList: (id)    l0
                          toList: (id)    l1
                         withTot: (float) tF;
- reproduce;          //genetic manipulation
- (Embryo *) getEmbryo;
- shuffle: (id) list;

//--------------------------------------------------------------------
@end
